/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.library.DryingRecipe;

public class DryingRecipeWrapper
extends BlankRecipeWrapper {
    protected final List<ItemStack> input;
    protected final List<ItemStack> output;
    protected final int time;

    public DryingRecipeWrapper(DryingRecipe recipe) {
        this.input = recipe.input.getInputs();
        this.output = ImmutableList.of((Object)recipe.getResult());
        this.time = recipe.getTime();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.input);
        ingredients.setOutputs(ItemStack.class, this.output);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int seconds;
        String minStr = "";
        String secStr = "";
        int minutes = this.time / 20 / 60;
        if (minutes > 0) {
            minStr = String.valueOf(minutes) + "m";
        }
        if ((seconds = this.time / 20 % 60) > 0) {
            if (minutes > 0) {
                secStr = secStr + " ";
            }
            secStr = secStr + String.valueOf(seconds) + "s";
        }
        String timeStr = minStr + secStr;
        int x = 80 - minecraft.field_71466_p.func_78256_a(timeStr) / 2;
        minecraft.field_71466_p.func_78276_b(timeStr, x, 5, Color.gray.getRGB());
    }
}

