/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.tileentity.TileCasting;

public class FluidHandlerCasting
implements IFluidHandler {
    private final FluidTankAnimated tank;
    private final TileCasting tileCasting;

    public FluidHandlerCasting(TileCasting tileCasting, FluidTankAnimated fluidTank) {
        this.tileCasting = tileCasting;
        this.tank = fluidTank;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        int capacity;
        if (resource == null || this.tileCasting.isStackInSlot(1)) {
            return 0;
        }
        Fluid fluid = resource.getFluid();
        if (this.tank.getFluidAmount() == 0 && (capacity = this.tileCasting.initNewCasting(fluid, doFill)) > 0) {
            FluidTank calcTank = new FluidTank(capacity);
            if (doFill) {
                this.tank.setCapacity(capacity);
                calcTank = this.tank;
            }
            return calcTank.fill(resource, doFill);
        }
        return this.tank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || this.tank.getFluidAmount() == 0) {
            return null;
        }
        if (this.tank.getFluid().getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain && this.tank.getFluidAmount() == 0) {
            this.tileCasting.reset();
        }
        return amount;
    }
}

