/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.mantle.client.gui.book.element.ElementImage;
import slimeknights.mantle.client.gui.book.element.ElementText;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.elements.ElementTinkerItem;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IModifierDisplay;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.tools.TinkerMaterials;

@SideOnly(value=Side.CLIENT)
public class ContentModifier
extends TinkerPage {
    public static final transient String ID = "modifier";
    public static final transient int TEX_SIZE = 256;
    public static final transient ImageData IMG_SLOT_1 = new ImageData(ClientProxy.BOOK_MODIFY, 0, 75, 22, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_2 = new ImageData(ClientProxy.BOOK_MODIFY, 0, 97, 40, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_3 = new ImageData(ClientProxy.BOOK_MODIFY, 0, 119, 58, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_5 = new ImageData(ClientProxy.BOOK_MODIFY, 0, 141, 58, 41, 256, 256);
    public static final transient ImageData IMG_TABLE = new ImageData(ClientProxy.BOOK_MODIFY, 214, 0, 42, 46, 256, 256);
    private transient IModifier modifier;
    private transient List<Item> tool;
    public TextData[] text;
    public String[] effects;
    @SerializedName(value="modifier")
    public String modifierName;
    public String[] demoTool = new String[]{Util.getResource("pickaxe").toString()};

    public ContentModifier() {
    }

    public ContentModifier(IModifier modifier) {
        this.modifier = modifier;
        this.modifierName = modifier.getIdentifier();
    }

    public void load() {
        if (this.modifierName == null) {
            this.modifierName = this.parent.name;
        }
        if (this.modifier == null) {
            this.modifier = TinkerRegistry.getModifier(this.modifierName);
        }
        if (this.tool == null) {
            this.tool = Lists.newArrayList();
            for (String entry : this.demoTool) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(entry));
                if (item == null) continue;
                this.tool.add(item);
            }
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        ImageData img;
        int color = 0xDDDDDD;
        int inCount = 1;
        ItemStack[][] inputItems = null;
        if (this.modifier instanceof IModifierDisplay) {
            int i;
            IModifierDisplay modifierDisplay = (IModifierDisplay)((Object)this.modifier);
            color = modifierDisplay.getColor();
            List<List<ItemStack>> inputList = modifierDisplay.getItems();
            inputItems = new ItemStack[5][];
            for (i = 0; i < 5; ++i) {
                inputItems[i] = new ItemStack[inputList.size()];
            }
            for (i = 0; i < inputList.size(); ++i) {
                String[] inputs = new ArrayList((Collection)inputList.get(i));
                if (inputs.size() > inCount) {
                    inCount = inputs.size();
                }
                for (int j = 0; j < inputs.size() && j < 5; ++j) {
                    ItemStack stack = (ItemStack)inputs.get(j);
                    if (stack != null && stack.func_77960_j() == Short.MAX_VALUE) {
                        stack = stack.func_77946_l();
                        stack.func_77964_b(0);
                    }
                    inputItems[j][i] = stack;
                }
            }
        }
        this.addTitle(list, CustomFontColor.encodeColor(color) + this.modifier.getLocalizedName(), true);
        int h = GuiBook.PAGE_WIDTH / 3 - 10;
        list.add((BookElement)new ElementText(10, 20, GuiBook.PAGE_WIDTH - 20, h, this.text));
        if (this.effects.length > 0) {
            TextData head = new TextData(this.parent.translate("modifier.effect"));
            head.underlined = true;
            list.add((BookElement)new ElementText(10, 20 + h, GuiBook.PAGE_WIDTH / 2 - 5, GuiBook.PAGE_HEIGHT - h - 20, new TextData[]{head}));
            ArrayList effectData = Lists.newArrayList();
            for (String e : this.effects) {
                effectData.add(new TextData("\u25cf "));
                effectData.add(new TextData(e));
                effectData.add(new TextData("\n"));
            }
            list.add((BookElement)new ElementText(10, 30 + h, GuiBook.PAGE_WIDTH / 2 + 5, GuiBook.PAGE_HEIGHT - h - 20, (Collection)effectData));
        }
        switch (inCount) {
            case 1: {
                img = IMG_SLOT_1;
                break;
            }
            case 2: {
                img = IMG_SLOT_2;
                break;
            }
            case 3: {
                img = IMG_SLOT_3;
                break;
            }
            default: {
                img = IMG_SLOT_5;
            }
        }
        int imgX = GuiBook.PAGE_WIDTH / 2 + 20;
        int imgY = GuiBook.PAGE_HEIGHT / 2 + 30;
        imgX = imgX + 29 - img.width / 2;
        imgY = imgY + 20 - img.height / 2;
        int[] slotX = new int[]{3, 21, 39, 12, 30};
        int[] slotY = new int[]{3, 3, 3, 22, 22};
        list.add((BookElement)new ElementImage(imgX + (img.width - ContentModifier.IMG_TABLE.width) / 2, imgY - 24, -1, -1, IMG_TABLE));
        list.add((BookElement)new ElementImage(imgX, imgY, -1, -1, img, book.appearance.slotColor));
        ItemStack[] demo = this.getDemoTools(inputItems);
        ElementTinkerItem toolItem = new ElementTinkerItem(imgX + (img.width - 16) / 2, imgY - 24, 1.0f, demo);
        toolItem.noTooltip = true;
        list.add((BookElement)toolItem);
        list.add((BookElement)new ElementImage(imgX + (img.width - 22) / 2, imgY - 27, -1, -1, IMG_SLOT_1, 0xFFFFFF));
        if (inputItems != null) {
            for (int i = 0; i < inCount && i < 5; ++i) {
                list.add((BookElement)new ElementTinkerItem(imgX + slotX[i], imgY + slotY[i], 1.0f, inputItems[i]));
            }
        }
    }

    protected ItemStack[] getDemoTools(ItemStack[][] inputItems) {
        ItemStack[] demo = new ItemStack[this.tool.size()];
        for (int i = 0; i < this.tool.size(); ++i) {
            if (this.tool.get(i) instanceof ToolCore) {
                ToolCore core = (ToolCore)this.tool.get(i);
                Object mats = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.cobalt), (Object)((Object)TinkerMaterials.ardite), (Object)((Object)TinkerMaterials.manyullyn));
                mats = mats.subList(0, core.getRequiredComponents().size());
                demo[i] = ((ToolCore)this.tool.get(i)).buildItemForRendering((List<Material>)mats);
            } else if (this.tool != null) {
                demo[i] = new ItemStack(this.tool.get(i));
            }
            if (demo[i] == null) continue;
            this.modifier.apply(demo[i]);
        }
        return demo;
    }
}

