/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityTurbineFluidPort
extends TileEntityTurbinePart
implements INeighborUpdatableEntity,
ITickableMultiblockPart,
IInputOutputPort {
    @CapabilityInject(value=IFluidHandler.class)
    private static Capability<IFluidHandler> CAPAB_FLUID_HANDLER = null;
    private IInputOutputPort.Direction _direction = IInputOutputPort.Direction.Input;
    private IFluidHandler _pumpDestination = null;

    @Override
    public IInputOutputPort.Direction getDirection() {
        return this._direction;
    }

    @Override
    public void setDirection(IInputOutputPort.Direction direction, boolean markForUpdate) {
        if (direction == this._direction) {
            return;
        }
        this._direction = direction;
        World world = this.func_145831_w();
        if (WorldHelper.calledByLogicalServer((World)world)) {
            WorldHelper.notifyBlockUpdate((World)world, (BlockPos)this.getWorldPosition(), null, null);
            this.notifyOutwardNeighborsOfStateChange();
            if (direction.isOutput()) {
                this.checkForAdjacentTank();
            }
            if (markForUpdate) {
                this.func_70296_d();
            } else {
                this.notifyNeighborsOfTileChange();
            }
        } else {
            world.func_175704_b(this.getWorldPosition(), this.getWorldPosition());
            this.notifyNeighborsOfTileChange();
        }
    }

    @Override
    public void toggleDirection(boolean markForUpdate) {
        this.setDirection(this._direction.opposite(), markForUpdate);
    }

    public void onPostMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onPostMachineAssembled(multiblockControllerBase);
        this.notifyOutwardNeighborsOfStateChange();
        this.checkForAdjacentTank();
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.notifyOutwardNeighborsOfStateChange();
        this._pumpDestination = null;
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (!data.func_74764_b("isInlet")) {
            return;
        }
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this._direction = IInputOutputPort.Direction.from(data.func_74767_n("isInlet"));
        } else {
            this.setDirection(IInputOutputPort.Direction.from(data.func_74767_n("isInlet")), false);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.func_74757_a("isInlet", this._direction.isInput());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return null != CAPAB_FLUID_HANDLER && CAPAB_FLUID_HANDLER == capability && this.isMachineAssembled() || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        MultiblockTurbine turbine;
        if (null != CAPAB_FLUID_HANDLER && CAPAB_FLUID_HANDLER == capability && null != (turbine = this.getTurbine()) && turbine.isAssembled()) {
            return (T)CAPAB_FLUID_HANDLER.cast((Object)turbine.getFluidHandler(this._direction));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onMultiblockServerTick() {
        if (null == this._pumpDestination || this._direction.isInput()) {
            return;
        }
        IFluidHandler fluidHandler = this.getTurbine().getFluidHandler(IInputOutputPort.Direction.Output);
        FluidStack fluidToDrain = fluidHandler.drain(4000, false);
        if (fluidToDrain != null && fluidToDrain.amount > 0) {
            fluidToDrain.amount = this._pumpDestination.fill(fluidToDrain, true);
            fluidHandler.drain(fluidToDrain, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, BlockPos position, IBlockState stateAtPosition, Block neighborBlock) {
        if (WorldHelper.calledByLogicalServer((World)this.func_145831_w())) {
            this.checkForAdjacentTank();
        }
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, BlockPos position, BlockPos neighbor) {
        if (WorldHelper.calledByLogicalServer((World)this.func_145831_w())) {
            this.checkForAdjacentTank();
        }
    }

    private void checkForAdjacentTank() {
        World world = this.func_145831_w();
        EnumFacing facing = this.getOutwardFacing();
        this._pumpDestination = null;
        if (null == facing || WorldHelper.calledByLogicalClient((World)world) || !this.isMachineAssembled() || this._direction.isInput()) {
            return;
        }
        TileEntity neighbor = world.func_175625_s(this.getWorldPosition().func_177972_a(facing));
        if (null != neighbor && neighbor.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing = facing.func_176734_d())) {
            this._pumpDestination = (IFluidHandler)neighbor.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        }
    }
}

