/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.api.IRadiationModerator;
import erogenousbeef.bigreactors.api.data.RadiationData;
import erogenousbeef.bigreactors.api.data.RadiationPacket;
import erogenousbeef.bigreactors.api.data.ReactorInteriorData;
import erogenousbeef.bigreactors.api.registry.ReactorInterior;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelAssembly;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelContainer;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import it.zerono.mods.zerocore.util.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;

public class RadiationHelper {
    public static final float fuelPerRadiationUnit = 7.0E-4f;
    public static final float rfPerRadiationUnit = 10.0f;
    public static final float fissionEventsPerFuelUnit = 0.01f;
    public static final ReactorInteriorData airData = new ReactorInteriorData(0.1f, 0.25f, 1.1f, 0.05f);
    public static final ReactorInteriorData waterData = new ReactorInteriorData(0.33f, 0.5f, 1.33f, 0.1f);
    private float fertility = 1.0f;

    public RadiationData radiate(World world, FuelContainer fuelContainer, TileEntityReactorFuelRod source, FuelAssembly fuelAssembly, float fuelHeat, float environmentHeat, int numControlRods) {
        TileEntityReactorControlRod controlRod = fuelAssembly.getControlRod();
        if (fuelContainer.getFuelAmount() <= 0) {
            return null;
        }
        RadiationData data = new RadiationData();
        data.fuelAbsorbedRadiation = 0.0f;
        double radiationPenaltyBase = Math.exp(-15.0 * Math.exp(-0.0025 * (double)fuelHeat));
        int baseFuelAmount = fuelContainer.getFuelAmount() + fuelContainer.getWasteAmount() / 100;
        float fuelReactivity = fuelContainer.getFuelReactivity();
        float rawRadIntensity = (float)baseFuelAmount * 0.01f;
        float scaledRadIntensity = (float)Math.pow(rawRadIntensity, fuelReactivity);
        scaledRadIntensity = (float)Math.pow(scaledRadIntensity / (float)numControlRods, fuelReactivity) * (float)numControlRods;
        float controlRodModifier = (float)(100 - controlRod.getControlRodInsertion()) / 100.0f;
        float effectiveRadIntensity = (scaledRadIntensity *= controlRodModifier) * (1.0f + (float)((double)-0.95f * Math.exp(-10.0 * Math.exp(-0.0012f * fuelHeat))));
        float radHardness = 0.2f + (float)(0.8 * radiationPenaltyBase);
        float rawFuelUsage = 7.0E-4f * (rawRadIntensity *= controlRodModifier) / this.getFertilityModifier() * BigReactors.CONFIG.fuelUsageMultiplier;
        data.fuelRfChange = 10.0f * effectiveRadIntensity;
        data.environmentRfChange = 0.0f;
        BlockPos originCoord = source.func_174877_v();
        effectiveRadIntensity *= 0.25f;
        RadiationPacket radPacket = new RadiationPacket();
        for (EnumFacing dir : fuelAssembly.getRadiateDirections()) {
            radPacket.hardness = radHardness;
            radPacket.intensity = effectiveRadIntensity;
            int ttl = 4;
            BlockPos currentCoord = originCoord;
            while (ttl > 0 && radPacket.intensity > 1.0E-4f) {
                --ttl;
                currentCoord = currentCoord.func_177972_a(dir);
                this.performIrradiation(world, data, radPacket, currentCoord);
            }
        }
        this.fertility += data.fuelAbsorbedRadiation;
        data.fuelAbsorbedRadiation = 0.0f;
        fuelContainer.onRadiationUsesFuel(rawFuelUsage);
        data.fuelUsage = rawFuelUsage;
        return data;
    }

    public void tick(boolean active) {
        float denominator = 20.0f;
        if (!active) {
            denominator *= 200.0f;
        }
        this.fertility = Math.max(0.0f, this.fertility - Math.max(0.1f, this.fertility / denominator));
    }

    private void performIrradiation(World world, RadiationData data, RadiationPacket radiation, BlockPos position) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof IRadiationModerator) {
            ((IRadiationModerator)te).moderateRadiation(data, radiation);
        } else if (world.func_175623_d(position)) {
            this.moderateByAir(data, radiation);
        } else {
            IBlockState blockState = world.func_180495_p(position);
            Block block = blockState.func_177230_c();
            if (block != null) {
                if (block.isAir(blockState, (IBlockAccess)world, position)) {
                    this.moderateByAir(data, radiation);
                } else if (block instanceof IFluidBlock) {
                    this.moderateByFluid(data, radiation, ((IFluidBlock)block).getFluid());
                } else {
                    this.moderateByBlock(data, radiation, blockState);
                }
            } else {
                this.moderateByAir(data, radiation);
            }
        }
    }

    private void moderateByAir(RadiationData data, RadiationPacket radiation) {
        RadiationHelper.applyModerationFactors(data, radiation, airData);
    }

    private void moderateByBlock(RadiationData data, RadiationPacket radiation, IBlockState blockState) {
        ReactorInteriorData moderatorData = null;
        Block block = blockState.func_177230_c();
        moderatorData = block == Blocks.field_150339_S ? ReactorInterior.getBlockData("blockIron") : (block == Blocks.field_150340_R ? ReactorInterior.getBlockData("blockGold") : (block == Blocks.field_150484_ah ? ReactorInterior.getBlockData("blockDiamond") : (block == Blocks.field_150475_bE ? ReactorInterior.getBlockData("blockEmerald") : (block == Blocks.field_150355_j || block == Blocks.field_150358_i ? waterData : ReactorInterior.getBlockData(ItemHelper.stackFrom((IBlockState)blockState, (int)1))))));
        if (moderatorData == null) {
            moderatorData = airData;
        }
        RadiationHelper.applyModerationFactors(data, radiation, moderatorData);
    }

    private void moderateByFluid(RadiationData data, RadiationPacket radiation, Fluid fluid) {
        ReactorInteriorData moderatorData = ReactorInterior.getFluidData(fluid.getName());
        if (moderatorData == null) {
            moderatorData = waterData;
        }
        RadiationHelper.applyModerationFactors(data, radiation, moderatorData);
    }

    private static void applyModerationFactors(RadiationData data, RadiationPacket radiation, ReactorInteriorData moderatorData) {
        float radiationAbsorbed = radiation.intensity * moderatorData.absorption * (1.0f - radiation.hardness);
        radiation.intensity = Math.max(0.0f, radiation.intensity - radiationAbsorbed);
        radiation.hardness /= moderatorData.moderation;
        data.environmentRfChange += moderatorData.heatEfficiency * radiationAbsorbed * 10.0f;
    }

    public float getFertility() {
        return this.fertility;
    }

    public float getFertilityModifier() {
        if (this.fertility <= 1.0f) {
            return 1.0f;
        }
        return (float)(Math.log10(this.fertility) + 1.0);
    }

    public void setFertility(float newFertility) {
        this.fertility = Float.isNaN(newFertility) || Float.isInfinite(newFertility) ? 1.0f : (newFertility < 0.0f ? 0.0f : newFertility);
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("fertility")) {
            this.setFertility(data.func_74760_g("fertility"));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74776_a("fertility", this.fertility);
        return data;
    }

    public void merge(RadiationHelper other) {
        this.fertility = Math.max(this.fertility, other.fertility);
    }
}

