/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.block;

import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.MineralType;
import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.block.BlockBR;
import erogenousbeef.bigreactors.common.block.OreType;
import erogenousbeef.bigreactors.init.BrItems;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BlockBROre
extends BlockBR {
    private List<ItemStack> _subBlocks = null;

    public BlockBROre(String blockName) {
        super(blockName, Material.field_151576_e);
    }

    @Override
    public void onPostRegister() {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockOre(this).setRegistryName(this.getRegistryName()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPostClientRegister() {
        ResourceLocation location = this.getRegistryName();
        Item item = Item.func_150898_a((Block)this);
        for (OreType ore : OreType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)ore.toMeta(), (ModelResourceLocation)new ModelResourceLocation(location, String.format("ore=%s", ore.func_176610_l())));
        }
    }

    @Override
    public void registerOreDictionaryEntries() {
        ItemStack ore = this.createItemStack(OreType.Yellorite, 1);
        OreDictionary.registerOre((String)"oreYellorite", (ItemStack)ore);
        OreDictionary.registerOre((String)"oreYellorium", (ItemStack)ore);
    }

    @Override
    public void registerRecipes() {
        ItemStack product;
        ItemStack ore = this.createItemStack(OreType.Yellorite, 1);
        if (BigReactors.CONFIG.registerYelloriteSmeltToUranium) {
            product = OreDictionaryHelper.getOre((String)"ingotUranium");
            if (null == product) {
                BRLog.warning("Config value registerYelloriteSmeltToUranium is set to True, but there are no ores registered as ingotUranium in the ore dictionary! Falling back to using standard yellorium only.", new Object[0]);
                product = OreDictionaryHelper.getOre((String)"ingotYellorium");
            }
        } else {
            product = OreDictionaryHelper.getOre((String)"ingotYellorium");
        }
        GameRegistry.addSmelting((ItemStack)ore, (ItemStack)product, (float)0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (null == this._subBlocks) {
            OreType[] types = OreType.VALUES;
            int length = types.length;
            this._subBlocks = new ArrayList<ItemStack>(length);
            for (int i = 0; i < length; ++i) {
                this._subBlocks.add(new ItemStack(item, 1, types[i].toMeta()));
            }
        }
        list.addAll(this._subBlocks);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(Properties.ORE, (Comparable)((Object)OreType.fromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((OreType)((Object)state.func_177229_b(Properties.ORE))).toMeta();
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        OreType type = (OreType)((Object)state.func_177229_b(Properties.ORE));
        MineralType mineral = type.getMineralDropped();
        return null == mineral ? super.func_180660_a(state, rand, fortune) : BrItems.minerals;
    }

    public int func_180651_a(IBlockState state) {
        OreType type = (OreType)((Object)state.func_177229_b(Properties.ORE));
        MineralType mineral = type.getMineralDropped();
        return null == mineral ? super.func_180651_a(state) : mineral.toMeta();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.createItemStack((OreType)((Object)state.func_177229_b(Properties.ORE)), 1);
    }

    public ItemStack createItemStack(OreType type, int amount) {
        return new ItemStack((Block)this, amount, type.toMeta());
    }

    public IBlockState getStateFromType(OreType type) {
        return this.func_176223_P().func_177226_a(Properties.ORE, (Comparable)((Object)type));
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        builder.add(new IProperty[]{Properties.ORE});
    }

    private static class ItemBlockOre
    extends ItemBlock {
        public ItemBlockOre(Block block) {
            super(block);
            this.func_77627_a(true);
            this.func_77656_e(0);
        }

        public String func_77667_c(ItemStack stack) {
            return super.func_77658_a() + "." + OreType.fromMeta(stack.func_77960_j()).func_176610_l();
        }

        public int func_77647_b(int meta) {
            return meta;
        }
    }
}

