/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.gui;

import erogenousbeef.bigreactors.gui.IBeefGuiControl;
import erogenousbeef.bigreactors.gui.IBeefListBoxEntry;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiListBox;
import erogenousbeef.bigreactors.gui.controls.grab.IBeefGuiGrabbable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BeefGuiBase
extends GuiContainer {
    protected List<IBeefGuiControl> controls;
    protected List<IBeefTooltipControl> controlsWithTooltips;
    protected List<GuiTextField> textFields;
    protected IBeefGuiGrabbable grabbedItem = null;

    public BeefGuiBase(Container container) {
        super(container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.controls = new ArrayList<IBeefGuiControl>();
        this.controlsWithTooltips = new ArrayList<IBeefTooltipControl>();
        this.textFields = new ArrayList<GuiTextField>();
    }

    public void registerControl(GuiTextField newTextField) {
        this.textFields.add(newTextField);
    }

    public void registerControl(IBeefGuiControl newControl) {
        this.controls.add(newControl);
        if (newControl instanceof IBeefTooltipControl) {
            this.controlsWithTooltips.add((IBeefTooltipControl)((Object)newControl));
        }
    }

    public void registerControl(GuiButton newButton) {
        this.field_146292_n.add(newButton);
        if (newButton instanceof IBeefTooltipControl) {
            this.controlsWithTooltips.add((IBeefTooltipControl)newButton);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int relativeX = mouseX - this.field_147003_i;
        int relativeY = mouseY - this.field_147009_r;
        for (IBeefGuiControl c : this.controls) {
            c.drawBackground(this.field_146297_k.field_71446_o, relativeX, relativeY);
        }
        for (GuiTextField field : this.textFields) {
            field.func_146194_f();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int absoluteX = mouseX - this.field_147003_i;
        int absoluteY = mouseY - this.field_147009_r;
        for (IBeefGuiControl c : this.controls) {
            c.drawForeground(this.field_146297_k.field_71446_o, mouseX, mouseY);
        }
        for (IBeefTooltipControl tc : this.controlsWithTooltips) {
            String[] tooltip;
            if (!tc.isVisible() || !tc.isMouseOver(mouseX, mouseY) || (tooltip = tc.getTooltip()) == null) continue;
            this.drawHoveringText(Arrays.asList(tooltip), absoluteX, absoluteY, this.field_146289_q);
            break;
        }
        if (this.grabbedItem != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModelRectFromIcon(absoluteX + 1, absoluteY + 1, this.grabbedItem.getIcon(), 16, 16);
        }
    }

    public void drawTexturedModelRectFromIcon(int x, int y, ResourceLocation texture, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        TextureManager textureManager = this.field_146297_k.field_71446_o;
        this.field_146297_k.func_147117_R();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite sprite = this.field_146297_k.func_147117_R().func_110572_b(texture.toString());
        float maxV = sprite.func_94210_h();
        float minV = sprite.func_94206_g();
        float maxU = sprite.func_94212_f();
        float minU = sprite.func_94209_e();
        vertexbuffer.func_181668_a(7, vertexbuffer.func_178973_g());
        vertexbuffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void func_73864_a(int x, int y, int buttonIndex) throws IOException {
        super.func_73864_a(x, y, buttonIndex);
        for (GuiTextField field : this.textFields) {
            field.func_146192_a(x, y, buttonIndex);
        }
        for (IBeefGuiControl c : this.controls) {
            c.onMouseClicked(x, y, buttonIndex);
        }
    }

    public abstract ResourceLocation getGuiBackground();

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void onListBoxSelectionChanged(BeefGuiListBox listBox, IBeefListBoxEntry selectedEntry) {
    }

    public void onListBoxEntryClicked(BeefGuiListBox listBox, IBeefListBoxEntry clickedEntry) {
    }

    public void setGrabbedItem(IBeefGuiGrabbable grabbedSource) {
        this.grabbedItem = grabbedSource;
    }

    public IBeefGuiGrabbable getGrabbedItem() {
        return this.grabbedItem;
    }

    public void onControlClicked(IBeefGuiControl control) {
    }
}

