/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.config;

import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.config.network.MessageClientOptions;
import io.github.drmanganese.topaddons.config.network.PacketHandler;
import io.github.drmanganese.topaddons.reference.Names;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConfigClient {
    public static final Map<String, Integer> VALUES = new HashMap<String, Integer>();
    private static final Map<String, Tuple<Integer, String>> DEFAULTS = new HashMap<String, Tuple<Integer, String>>();

    public static void init(Configuration config) {
        config.load();
        DEFAULTS.forEach((s, t) -> VALUES.put((String)s, config.getInt(s, "Options", ((Integer)t.func_76341_a()).intValue(), 0, 1, (String)t.func_76340_b())));
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public static void onConfigChangedOnConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("topaddons")) {
            DEFAULTS.forEach((s, t) -> VALUES.put((String)s, TOPAddons.configClient.getInt(s, "Options", ((Integer)t.func_76341_a()).intValue(), 0, 1, (String)t.func_76340_b())));
            if (Minecraft.func_71410_x().field_71441_e != null) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageClientOptions(VALUES, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            }
        }
    }

    public static void set(String key, int value) {
        TOPAddons.configClient.get("Options", key, ((Integer)DEFAULTS.get(key).func_76341_a()).intValue(), (String)DEFAULTS.get(key).func_76340_b(), 0, Names.clientConfigOptions.get(key) == Boolean.TYPE ? 1 : Integer.MAX_VALUE).set(value);
        VALUES.put(key, value);
        TOPAddons.configClient.save();
    }

    static {
        DEFAULTS.put("fluidGauge", (Tuple<Integer, String>)new Tuple((Object)1, (Object)"Display the TOP Addons fluid gauge for internal tanks on tiles (0 to disable)."));
        DEFAULTS.put("hideTOPTank", (Tuple<Integer, String>)new Tuple((Object)0, (Object)"Hide the vanilla TOP fluid gauge (1 to hide)."));
        DEFAULTS.put("forestryReasonCrouch", (Tuple<Integer, String>)new Tuple((Object)0, (Object)"Only show Forestry machines' important failure reasons when crouching (1 to enable)."));
        DEFAULTS.put("showPitch", (Tuple<Integer, String>)new Tuple((Object)1, (Object)"Display pitch and instrument on Note Blocks (0 to disable)."));
        DEFAULTS.put("ic2Progress", (Tuple<Integer, String>)new Tuple((Object)0, (Object)"Show IC\u00c2\u00b2 machine progress bar (0: Extended mode, 1: Normal mode)."));
    }
}

