/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import WayofTime.bloodmagic.altar.BloodAltar;
import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.iface.IAltarReader;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.orb.BloodOrb;
import WayofTime.bloodmagic.api.orb.IBloodOrb;
import WayofTime.bloodmagic.api.registry.OrbRegistry;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.item.armour.ItemSentientArmour;
import WayofTime.bloodmagic.item.sigil.ItemSigilHolding;
import WayofTime.bloodmagic.item.sigil.ItemSigilSeer;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.routing.IMasterRoutingNode;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.tile.TileIncenseAltar;
import WayofTime.bloodmagic.tile.routing.TileFilteredRoutingNode;
import WayofTime.bloodmagic.util.helper.NumeralHelper;
import io.github.drmanganese.topaddons.TOPRegistrar;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.Config;
import io.github.drmanganese.topaddons.elements.bloodmagic.ElementAltarCrafting;
import io.github.drmanganese.topaddons.elements.bloodmagic.ElementNodeFilter;
import io.github.drmanganese.topaddons.reference.EnumChip;
import io.github.drmanganese.topaddons.reference.Names;
import java.util.HashMap;
import java.util.Map;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@TOPAddon(dependency="BloodMagic")
public class AddonBloodMagic
extends AddonBlank {
    public static int ELEMENT_NODE_FILTER;
    public static int ELEMENT_ALTAR_CRAFTING;

    @Override
    public boolean hasSpecialHelmets() {
        return true;
    }

    @Override
    public Map<Class<? extends ItemArmor>, EnumChip> getSpecialHelmets() {
        HashMap<Class<? extends ItemArmor>, EnumChip> map = new HashMap<Class<? extends ItemArmor>, EnumChip>();
        map.put(ItemLivingArmour.class, EnumChip.STANDARD);
        map.put(ItemSentientArmour.class, EnumChip.STANDARD);
        return map;
    }

    @Override
    public void registerElements() {
        ELEMENT_NODE_FILTER = TOPRegistrar.GetTheOneProbe.probe.registerElementFactory(ElementNodeFilter::new);
        ELEMENT_ALTAR_CRAFTING = TOPRegistrar.GetTheOneProbe.probe.registerElementFactory(ElementAltarCrafting::new);
    }

    @Override
    public void addTankNames() {
        Names.tankNamesMap.put(TileAltar.class, new String[]{"Blood Altar"});
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        boolean holdingSigil = !Config.BloodMagic.requireSigil || this.isAltarSeer(player.func_184586_b(EnumHand.MAIN_HAND)) || this.isAltarSeer(player.func_184586_b(EnumHand.OFF_HAND));
        boolean holdingSeer = !Config.BloodMagic.requireSigil || this.holdingSeer(player.func_184586_b(EnumHand.MAIN_HAND)) || this.holdingSeer(player.func_184586_b(EnumHand.OFF_HAND));
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile != null) {
            BlockPos sidePos;
            TileFilteredRoutingNode node;
            ItemStack filterStack;
            IBloodAltar altar;
            if (tile instanceof IBloodAltar && holdingSigil) {
                altar = (IBloodAltar)tile;
                this.textPrefixed(probeInfo, "Tier", NumeralHelper.toRoman((int)altar.getTier().toInt()), TextFormatting.RED);
                if (altar instanceof TileAltar && holdingSeer) {
                    ItemStack result;
                    ItemStack input = ((TileAltar)altar).func_70301_a(0);
                    if (input == null) {
                        return;
                    }
                    BloodAltar bloodAltar = (BloodAltar)ReflectionHelper.getPrivateValue(TileAltar.class, (Object)((TileAltar)altar), (String[])new String[]{"bloodAltar"});
                    if (input.func_77973_b() instanceof IBloodOrb) {
                        SoulNetwork network = NetworkHelper.getSoulNetwork((String)((IBindable)input.func_77973_b()).getOwnerUUID(input));
                        BloodOrb orb = OrbRegistry.getOrb((int)(network.getOrbTier() - 1));
                        this.addAltarCraftingElement(probeInfo, input, new ItemStack(ModItems.BLOOD_ORB, 1, network.getOrbTier() - 1), network.getCurrentEssence(), orb.getCapacity(), 0.0f);
                    } else if (altar.isActive() && (result = (ItemStack)ReflectionHelper.getPrivateValue(BloodAltar.class, (Object)bloodAltar, (String[])new String[]{"result"})) != null) {
                        this.addAltarCraftingElement(probeInfo, input, result, bloodAltar.getProgress(), bloodAltar.getLiquidRequired(), bloodAltar.getConsumptionRate());
                    }
                }
            }
            if (tile instanceof TileFilteredRoutingNode && !(tile instanceof IMasterRoutingNode) && (filterStack = (node = (TileFilteredRoutingNode)tile).getFilterStack(data.getSideHit())) != null && world.func_175625_s(sidePos = data.getPos().func_177972_a(data.getSideHit())) != null) {
                IBlockState sideState = world.func_180495_p(sidePos);
                ItemStack inventoryOnSide = sideState.func_177230_c().getPickBlock(sideState, new RayTraceResult(data.getHitVec(), data.getSideHit().func_176734_d(), sidePos), world, sidePos, player);
                this.addFilterElement(probeInfo, data.getSideHit().func_176610_l(), inventoryOnSide, filterStack);
            }
            if (tile instanceof TileIncenseAltar && holdingSigil) {
                altar = (TileIncenseAltar)tile;
                this.textPrefixed(probeInfo, "Tranquility", (int)(100.0 * (double)((int)(100.0 * altar.tranquility)) / 100.0) + "", TextFormatting.RED);
                this.textPrefixed(probeInfo, "Bonus", (int)(altar.incenseAddition * 100.0) + "%", TextFormatting.RED);
            }
        }
    }

    private void addFilterElement(IProbeInfo probeInfo, String side, ItemStack inventoryOnSide, ItemStack filterStack) {
        probeInfo.element((IElement)new ElementNodeFilter(side, inventoryOnSide, filterStack));
    }

    private void addAltarCraftingElement(IProbeInfo probeInfo, ItemStack input, ItemStack result, int progress, int required, float consumption) {
        probeInfo.element((IElement)new ElementAltarCrafting(input, result, progress, required * input.field_77994_a, consumption));
    }

    private boolean isAltarSeer(ItemStack heldStack) {
        if (heldStack == null) {
            return false;
        }
        if (heldStack.func_77973_b() instanceof IAltarReader) {
            if (heldStack.func_77973_b() instanceof ItemSigilHolding) {
                ItemStack currentHoldingStack = ItemSigilHolding.getItemStackInSlot((ItemStack)heldStack, (int)ItemSigilHolding.getCurrentItemOrdinal((ItemStack)heldStack));
                return currentHoldingStack != null && currentHoldingStack.func_77973_b() instanceof IAltarReader;
            }
            return true;
        }
        return false;
    }

    private boolean holdingSeer(ItemStack heldStack) {
        return heldStack != null && heldStack.func_77973_b() instanceof ItemSigilSeer;
    }
}

