/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.IPlantable;

public class TileEntityGreenhouseGlass
extends TileEntityBase {
    private int timeUntilNextFert;

    public TileEntityGreenhouseGlass() {
        super("greenhouseGlass");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.timeUntilNextFert = compound.func_74762_e("Time");
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Time", this.timeUntilNextFert);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_175710_j(this.func_174877_v()) && this.field_145850_b.func_72935_r()) {
            if (this.timeUntilNextFert > 0) {
                BlockPos blockToFert;
                --this.timeUntilNextFert;
                if (this.timeUntilNextFert <= 0 && (blockToFert = this.blockToFertilize()) != null) {
                    IBlockState state = this.field_145850_b.func_180495_p(blockToFert);
                    Block block = state.func_177230_c();
                    int metaBefore = block.func_176201_c(state);
                    block.func_180650_b(this.field_145850_b, blockToFert, this.field_145850_b.func_180495_p(blockToFert), this.field_145850_b.field_73012_v);
                    IBlockState newState = this.field_145850_b.func_180495_p(blockToFert);
                    if (newState.func_177230_c().func_176201_c(newState) != metaBefore) {
                        this.field_145850_b.func_175718_b(2005, blockToFert, 0);
                    }
                }
            } else {
                int time = 100;
                this.timeUntilNextFert = time + this.field_145850_b.field_73012_v.nextInt(time);
            }
        }
    }

    public BlockPos blockToFertilize() {
        for (int i = this.field_174879_c.func_177956_o() - 1; i > 0; --i) {
            BlockPos offset = new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p());
            Block block = this.field_145850_b.func_180495_p(offset).func_177230_c();
            if (block == null || this.field_145850_b.func_175623_d(offset)) continue;
            if ((block instanceof IGrowable || block instanceof IPlantable) && !(block instanceof BlockGrass)) {
                return offset;
            }
            return null;
        }
        return null;
    }
}

