/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ItemWingsOfTheBats
extends ItemBase {
    public static final ArrayList<String> WINGED_PLAYERS = new ArrayList();

    public ItemWingsOfTheBats(String name) {
        super(name);
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isPlayerWinged(EntityPlayer player) {
        return WINGED_PLAYERS.contains(player.func_110124_au() + (player.field_70170_p.field_72995_K ? "-Remote" : ""));
    }

    public static void removeWingsFromPlayer(EntityPlayer player) {
        ItemWingsOfTheBats.removeWingsFromPlayer(player, player.field_70170_p.field_72995_K);
    }

    public static void removeWingsFromPlayer(EntityPlayer player, boolean worldRemote) {
        WINGED_PLAYERS.remove(player.func_110124_au() + (worldRemote ? "-Remote" : ""));
    }

    public static void addWingsToPlayer(EntityPlayer player) {
        WINGED_PLAYERS.add(player.func_110124_au() + (player.field_70170_p.field_72995_K ? "-Remote" : ""));
    }

    public static ItemStack getWingItem(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (!StackUtil.isValid(player.field_71071_by.func_70301_a(i)) || !(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof ItemWingsOfTheBats)) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        return StackUtil.getNull();
    }

    @SubscribeEvent
    public void onLogOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        ItemWingsOfTheBats.removeWingsFromPlayer(event.player, true);
        ItemWingsOfTheBats.removeWingsFromPlayer(event.player, false);
    }

    @SubscribeEvent
    public void onEntityDropEvent(LivingDropsEvent event) {
        if (event.getEntityLiving().field_70170_p != null && !event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer && ConfigBoolValues.DO_BAT_DROPS.isEnabled() && event.getEntityLiving() instanceof EntityBat && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(15) <= event.getLootingLevel() * 2) {
            event.getDrops().add(new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(InitItems.itemMisc, event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2 + event.getLootingLevel()) + 1, TheMiscItems.BAT_WING.ordinal())));
        }
    }

    @SubscribeEvent
    public void livingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean wingsEquipped = StackUtil.isValid(ItemWingsOfTheBats.getWingItem(player));
            if (!ItemWingsOfTheBats.isPlayerWinged(player)) {
                if (wingsEquipped) {
                    ItemWingsOfTheBats.addWingsToPlayer(player);
                }
            } else if (wingsEquipped) {
                player.field_71075_bZ.field_75101_c = true;
            } else {
                ItemWingsOfTheBats.removeWingsFromPlayer(player);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.field_71075_bZ.field_75102_a = false;
                }
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

