/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import team.chisel.Chisel;
import team.chisel.api.render.IChiselFace;
import team.chisel.api.render.IChiselTexture;
import team.chisel.common.util.json.JsonFace;
import team.chisel.common.util.json.JsonTexture;

public class JsonHelper {
    private static RuntimeException cachedException;
    private static final Gson gson;
    private static Map<ResourceLocation, JsonObject> objectCache;
    private static Map<ResourceLocation, IChiselFace> faceCache;
    private static Map<ResourceLocation, IChiselTexture<?>> textureCache;
    public static final String FACE_EXTENSION = ".cf";
    public static final String TEXTURE_EXTENSION = ".ctx";
    public static final JsonObject NORMAL_TEXTURE;
    public static final String NORMAL_FACE = "{\"textures\":[\".%s\"]}";

    private static IChiselFace createFace(ResourceLocation loc) {
        if (JsonHelper.isValidFace(loc)) {
            JsonObject object = objectCache.get(loc);
            JsonFace face = (JsonFace)gson.fromJson((JsonElement)object, JsonFace.class);
            IChiselFace cFace = (IChiselFace)face.get(loc);
            faceCache.put(loc, cFace);
            return cFace;
        }
        if (cachedException != null && cachedException.getCause() instanceof FileNotFoundException) {
            String path = loc.func_110623_a();
            if (loc.func_110623_a().indexOf(47) < 0) {
                path = '/' + path;
            }
            path = path.substring(path.lastIndexOf(47)).replace(FACE_EXTENSION, TEXTURE_EXTENSION);
            objectCache.put(loc, (JsonObject)gson.fromJson(String.format(NORMAL_FACE, path), JsonObject.class));
            Chisel.debug("Substituting default face json for missing file " + loc);
            JsonHelper.clearException();
            return JsonHelper.createFace(loc);
        }
        throw JsonHelper.clearException();
    }

    private static IChiselTexture<?> createTexture(ResourceLocation loc) {
        if (JsonHelper.isCombinedTexture(false, loc)) {
            JsonObject object = objectCache.get(loc);
            JsonTexture texture = (JsonTexture)gson.fromJson((JsonElement)object, JsonTexture.class);
            IChiselTexture cTexture = (IChiselTexture)texture.get(loc);
            textureCache.put(loc, cTexture);
            return cTexture;
        }
        if (cachedException != null && cachedException.getCause() instanceof FileNotFoundException) {
            objectCache.put(loc, NORMAL_TEXTURE);
            Chisel.debug("Substituting default texture json for missing file " + loc);
            JsonHelper.clearException();
            return JsonHelper.createTexture(loc);
        }
        throw JsonHelper.clearException();
    }

    public static void flushCaches() {
        Chisel.debug("Flushing Json caches");
        objectCache.clear();
        faceCache.clear();
        textureCache.clear();
    }

    public static IChiselFace getOrCreateFace(ResourceLocation loc) {
        if (faceCache.containsKey(loc)) {
            return faceCache.get(loc);
        }
        return JsonHelper.createFace(loc);
    }

    public static IChiselTexture<?> getOrCreateTexture(ResourceLocation loc) {
        if (textureCache.containsKey(loc)) {
            return textureCache.get(loc);
        }
        return JsonHelper.createTexture(loc);
    }

    public static boolean isValidTexture(ResourceLocation loc) {
        ResourceLocation absolute = new ResourceLocation(loc.func_110624_b(), "textures/blocks/" + loc.func_110623_a());
        return JsonHelper.isValid(loc, absolute);
    }

    public static boolean isValidFace(ResourceLocation loc) {
        ResourceLocation absolute = new ResourceLocation(loc.func_110624_b(), "models/block/" + loc.func_110623_a());
        if (JsonHelper.isValid(loc, absolute)) {
            JsonObject obj = objectCache.get(loc);
            return obj.has("textures") && !obj.has("type");
        }
        return false;
    }

    private static boolean isValid(ResourceLocation relative, ResourceLocation absolute) {
        JsonObject object;
        JsonHelper.clearException();
        if (objectCache.containsKey(relative)) {
            return true;
        }
        if (!JsonHelper.isLoadable(absolute)) {
            objectCache.put(relative, NORMAL_TEXTURE);
            return true;
        }
        try {
            object = (JsonObject)gson.fromJson((Reader)new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(absolute).func_110527_b()), JsonObject.class);
        }
        catch (JsonSyntaxException | IOException e) {
            cachedException = new RuntimeException("Error loading file " + absolute, e);
            return false;
        }
        if (object.has("textures") || object.has("type")) {
            objectCache.put(relative, object);
            return true;
        }
        throw new IllegalArgumentException(relative + " does not have a 'textures' and/or 'type' field!");
    }

    private static boolean isLoadable(ResourceLocation loc) {
        return loc.func_110623_a().endsWith(TEXTURE_EXTENSION) || loc.func_110623_a().endsWith(FACE_EXTENSION);
    }

    public static boolean isCombinedTexture(boolean combined, ResourceLocation loc) {
        if (JsonHelper.isValidTexture(loc)) {
            JsonObject object = objectCache.get(loc);
            boolean ret = object.has("children") && !object.has("type");
            return ret == combined;
        }
        return false;
    }

    public static RuntimeException clearException() {
        RuntimeException e = cachedException;
        cachedException = null;
        return e;
    }

    public static boolean isFace(ResourceLocation loc) {
        return faceCache.containsKey(loc);
    }

    public static boolean isTex(ResourceLocation loc) {
        return textureCache.containsKey(loc);
    }

    public static boolean isLocalPath(String path) {
        return path.startsWith("./");
    }

    public static String toAbsolutePath(String localPath, ResourceLocation loc) {
        String path = loc.func_110623_a();
        path = path.substring(0, path.lastIndexOf(47) + 1);
        return loc.func_110624_b() + ":" + path + localPath.substring(2);
    }

    public static String toTexturePath(String resourcePath) {
        String s = resourcePath.replace("textures/", "").replace(TEXTURE_EXTENSION, "");
        if (!s.startsWith("blocks")) {
            s = "blocks/".concat(s);
        }
        return s;
    }

    static {
        gson = new Gson();
        objectCache = new HashMap<ResourceLocation, JsonObject>();
        faceCache = new HashMap<ResourceLocation, IChiselFace>();
        textureCache = new HashMap();
        NORMAL_TEXTURE = (JsonObject)gson.fromJson("{\"type\": \"NORMAL\"}", JsonObject.class);
    }
}

