/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Point2i;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.math.BlockPos;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureInfo;
import team.chisel.client.render.Quad;
import team.chisel.client.render.ctm.Submap;
import team.chisel.client.render.ctx.BlockRenderContextGridTexture;
import team.chisel.client.render.ctx.BlockRenderContextPosition;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeMap;

public class ChiselTextureMap
extends AbstractChiselTexture<BlockRenderTypeMap> {
    private final int xSize;
    private final int ySize;
    private final MapType map;

    public ChiselTextureMap(BlockRenderTypeMap type, TextureInfo info, MapType map) {
        super(type, info);
        this.map = map;
        if (this.info.isPresent()) {
            JsonObject object = (JsonObject)this.info.get();
            if (object.has("width") && object.has("height")) {
                Preconditions.checkArgument((object.get("width").isJsonPrimitive() && object.get("width").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"width must be a number!");
                Preconditions.checkArgument((object.get("height").isJsonPrimitive() && object.get("height").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"height must be a number!");
                this.xSize = object.get("width").getAsInt();
                this.ySize = object.get("height").getAsInt();
            } else if (object.has("size")) {
                Preconditions.checkArgument((object.get("size").isJsonPrimitive() && object.get("size").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"size must be a number!");
                this.xSize = object.get("size").getAsInt();
                this.ySize = object.get("size").getAsInt();
            } else {
                this.ySize = 2;
                this.xSize = 2;
            }
        } else {
            this.ySize = 2;
            this.xSize = 2;
        }
        Preconditions.checkArgument((this.xSize > 0 && this.ySize > 0 ? 1 : 0) != 0, (Object)"Cannot have a dimension of 0!");
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, IBlockRenderContext context, int quadGoal) {
        return this.map.transformQuad(this, quad, context, quadGoal);
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public static enum MapType {
        RANDOM{

            @Override
            protected List<BakedQuad> transformQuad(ChiselTextureMap tex, BakedQuad quad, @Nullable IBlockRenderContext context, int quadGoal) {
                Point2i textureCoords = context == null ? new Point2i(1, 1) : ((BlockRenderContextGridTexture)context).getTextureCoords(quad.func_178210_d());
                float intervalX = 16.0f / (float)tex.getXSize();
                float intervalY = 16.0f / (float)tex.getYSize();
                float maxU = (float)textureCoords.x * intervalX;
                float maxV = (float)textureCoords.y * intervalY;
                Submap uvs = new Submap(intervalX, intervalY, maxU - intervalX, maxV - intervalY);
                Quad q = Quad.from(quad).setFullbright(tex.fullbright);
                if (quadGoal != 4) {
                    return Collections.singletonList(q.transformUVs(tex.sprites[0].getSprite(), uvs).setFullbright(tex.fullbright).rebake());
                }
                Quad[] quads = q.subdivide(4);
                for (int i = 0; i < quads.length; ++i) {
                    if (quads[i] == null) continue;
                    quads[i] = quads[i].transformUVs(tex.sprites[0].getSprite(), uvs);
                }
                return Arrays.stream(quads).filter(Objects::nonNull).map(Quad::rebake).collect(Collectors.toList());
            }

            @Override
            public IBlockRenderContext getContext(@Nonnull BlockPos pos, @Nonnull ChiselTextureMap tex) {
                return new BlockRenderContextGridTexture.Random(pos, tex).applyOffset();
            }
        }
        ,
        PATTERNED{

            @Override
            protected List<BakedQuad> transformQuad(ChiselTextureMap tex, BakedQuad quad, @Nullable IBlockRenderContext context, int quadGoal) {
                Point2i textureCoords = context == null ? new Point2i(0, 0) : ((BlockRenderContextGridTexture)context).getTextureCoords(quad.func_178210_d());
                float intervalU = 16.0f / (float)tex.xSize;
                float intervalV = 16.0f / (float)tex.ySize;
                float minU = intervalU * (float)textureCoords.x;
                float minV = intervalV * (float)textureCoords.y;
                Submap submap = new Submap(intervalU, intervalV, minU, minV);
                Quad q = Quad.from(quad).setFullbright(tex.fullbright);
                if (quadGoal != 4) {
                    return Collections.singletonList(q.transformUVs(tex.sprites[0].getSprite(), submap).rebake());
                }
                Quad[] quads = q.subdivide(4);
                for (int i = 0; i < quads.length; ++i) {
                    if (quads[i] == null) continue;
                    quads[i] = quads[i].transformUVs(tex.sprites[0].getSprite(), submap);
                }
                return Arrays.stream(quads).filter(Objects::nonNull).map(Quad::rebake).collect(Collectors.toList());
            }

            @Override
            public IBlockRenderContext getContext(@Nonnull BlockPos pos, @Nonnull ChiselTextureMap tex) {
                return new BlockRenderContextGridTexture.Patterned(pos, tex).applyOffset();
            }
        };


        protected abstract List<BakedQuad> transformQuad(ChiselTextureMap var1, BakedQuad var2, @Nullable IBlockRenderContext var3, int var4);

        public IBlockRenderContext getContext(@Nonnull BlockPos pos, @Nonnull ChiselTextureMap tex) {
            return new BlockRenderContextPosition(pos);
        }
    }
}

