/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureInfo;
import team.chisel.client.render.Quad;
import team.chisel.client.render.ctm.CTM;
import team.chisel.client.render.ctx.CTMBlockRenderContext;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeCTM;

public class ChiselTextureCTM
extends AbstractChiselTexture<BlockRenderTypeCTM> {
    public ChiselTextureCTM(BlockRenderTypeCTM type, TextureInfo info) {
        super(type, info);
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad bq, IBlockRenderContext context, int quadGoal) {
        Quad quad = Quad.from(bq).setFullbright(this.fullbright);
        if (context == null) {
            return Collections.singletonList(quad.transformUVs(this.sprites[0].getSprite()).rebake());
        }
        Quad[] quads = quad.subdivide(4);
        int[] ctm = ((CTMBlockRenderContext)context).getCTM(bq.func_178210_d()).getSubmapIndices();
        for (int i = 0; i < quads.length; ++i) {
            Quad q2 = quads[i];
            if (q2 == null) continue;
            int ctmid = q2.getUvs().normalize().getQuadrant();
            quads[i] = q2.grow().transformUVs(this.sprites[ctm[ctmid] > 15 ? 0 : 1].getSprite(), CTM.uvs[ctm[ctmid]].normalize());
        }
        return Arrays.stream(quads).filter(Objects::nonNull).map(q -> q.rebake()).collect(Collectors.toList());
    }
}

