/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class RegionCache
implements IBlockAccess {
    private final BlockPos center;
    private final int radius;
    private final IBlockAccess passthrough;
    private final Function<BlockPos, IBlockState> lookupFunc;
    private final Map<BlockPos, IBlockState> stateCache = new HashMap<BlockPos, IBlockState>();

    public RegionCache(BlockPos center, int radius, IBlockAccess passthrough) {
        this.center = center;
        this.radius = radius;
        this.passthrough = passthrough;
        this.lookupFunc = arg_0 -> ((IBlockAccess)passthrough).func_180495_p(arg_0);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.passthrough.func_175625_s(pos);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return this.passthrough.func_175626_b(pos, lightValue);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.stateCache.computeIfAbsent(pos, this.lookupFunc);
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.passthrough.func_180494_b(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.passthrough.func_175627_a(pos, direction);
    }

    public WorldType func_175624_G() {
        return this.passthrough.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.passthrough.isSideSolid(pos, side, _default);
    }
}

