/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.render;

import com.google.common.collect.Maps;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.IBlockRenderType;
import team.chisel.api.render.IChiselTexture;

@ParametersAreNonnullByDefault
public class RenderContextList {
    private final IBlockState state;
    private final Map<IBlockRenderType, IBlockRenderContext> contextMap = Maps.newIdentityHashMap();
    private final TLongSet serialized = new TLongHashSet();

    public RenderContextList(IBlockState state, List<IChiselTexture<?>> textures, IBlockAccess world, BlockPos pos) {
        this.state = state;
        for (IChiselTexture<?> tex : textures) {
            Object type = tex.getType();
            IBlockRenderContext ctx = type.getBlockRenderContext(state, world, pos, tex);
            if (ctx == null) continue;
            this.contextMap.put((IBlockRenderType)type, ctx);
        }
        for (IBlockRenderContext ctx : this.contextMap.values()) {
            this.serialized.add(ctx.getCompressedData());
        }
    }

    @Nullable
    public IBlockRenderContext getRenderContext(IBlockRenderType type) {
        return this.contextMap.get(type);
    }

    public boolean contains(IBlockRenderType type) {
        return this.getRenderContext(type) != null;
    }

    public TLongSet serialized() {
        return this.serialized;
    }
}

