/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import net.minecraft.entity.Entity;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntityListWrapper;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;
import vazkii.psi.common.spell.trick.entity.PieceTrickAddMotion;

public class PieceTrickMassAddMotion
extends PieceTrick {
    SpellParam target;
    SpellParam direction;
    SpellParam speed;

    public PieceTrickMassAddMotion(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntityListWrapper("psi.spellparam.target", 13814826, false, false);
        this.addParam(this.target);
        this.direction = new ParamVector("psi.spellparam.direction", 4117034, false, false);
        this.addParam(this.direction);
        this.speed = new ParamNumber("psi.spellparam.speed", 0xD22A2A, false, true);
        this.addParam(this.speed);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double speedVal = (Double)this.getParamEvaluation(this.speed);
        if (speedVal == null) {
            speedVal = 1.0;
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(Math.abs(speedVal) * 100.0));
        meta.addStat(EnumSpellStat.COST, (int)(Math.abs(speedVal) * 120.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        EntityListWrapper targetVal = (EntityListWrapper)this.getParamValue(context, this.target);
        Vector3 directionVal = (Vector3)this.getParamValue(context, this.direction);
        Double speedVal = (Double)this.getParamValue(context, this.speed);
        for (Entity e : targetVal) {
            PieceTrickAddMotion.addMotion(context, e, directionVal, speedVal);
        }
        return null;
    }
}

