/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.util.math.BlockPos;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickPlaceBlock;

public class PieceTrickPlaceInSequence
extends PieceTrick {
    SpellParam position;
    SpellParam target;
    SpellParam maxBlocks;

    public PieceTrickPlaceInSequence(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", 4117034, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", 0xD22A2A, false, true);
        this.addParam(this.maxBlocks);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double maxBlocksVal = (Double)this.getParamEvaluation(this.maxBlocks);
        if (maxBlocksVal == null || maxBlocksVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 8.0));
        meta.addStat(EnumSpellStat.COST, (int)(maxBlocksVal * 8.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        Vector3 targetVal = (Vector3)this.getParamValue(context, this.target);
        Double maxBlocksVal = (Double)this.getParamValue(context, this.maxBlocks);
        int maxBlocksInt = maxBlocksVal.intValue();
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        int len = (int)targetVal.mag();
        Vector3 targetNorm = targetVal.copy().normalize();
        for (int i = 0; i < Math.min(len, maxBlocksInt); ++i) {
            Vector3 blockVec = positionVal.copy().add(targetNorm.copy().multiply(i));
            if (!context.isInRadius(blockVec)) {
                throw new SpellRuntimeException("psi.spellerror.outsideradius");
            }
            BlockPos pos = new BlockPos(blockVec.x, blockVec.y, blockVec.z);
            PieceTrickPlaceBlock.placeBlock(context.caster, context.caster.field_70170_p, pos, context.getTargetSlot(), false);
        }
        return null;
    }
}

