/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.selector.entity;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceSelector;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;

public abstract class PieceSelectorNearby
extends PieceSelector {
    SpellParam position;
    SpellParam radius;

    public PieceSelectorNearby(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
        this.radius = new ParamNumber("psi.spellparam.radius", 4117034, false, true);
        this.addParam(this.radius);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double radiusVal = (Double)this.getParamEvaluation(this.radius);
        if (radiusVal == null || radiusVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        Double radiusVal = (Double)this.getParamValue(context, this.radius);
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        AxisAlignedBB axis = new AxisAlignedBB(positionVal.x - radiusVal, positionVal.y - radiusVal, positionVal.z - radiusVal, positionVal.x + radiusVal, positionVal.y + radiusVal, positionVal.z + radiusVal);
        Predicate<Entity> pred = this.getTargetPredicate();
        List list = context.caster.field_70170_p.func_175647_a(Entity.class, axis, e -> e != null && pred.apply(e) && e != context.caster && e != context.focalPoint && context.isInRadius((Entity)e));
        return new EntityListWrapper(list);
    }

    public abstract Predicate<Entity> getTargetPredicate();

    @Override
    public Class<?> getEvaluationType() {
        return EntityListWrapper.class;
    }
}

