/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.psi.api.spell.IRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;

public final class SpellGrid {
    private static final String TAG_SPELL_LIST = "spellList";
    private static final String TAG_SPELL_POS_X_LEGACY = "spellPosX";
    private static final String TAG_SPELL_POS_Y_LEGACY = "spellPosY";
    private static final String TAG_SPELL_DATA_LEGACY = "spellData";
    private static final String TAG_SPELL_POS_X = "x";
    private static final String TAG_SPELL_POS_Y = "y";
    private static final String TAG_SPELL_DATA = "data";
    public static final int GRID_SIZE = 9;
    public final Spell spell;
    public SpellPiece[][] gridData;

    @SideOnly(value=Side.CLIENT)
    public void draw() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(i * 18), (float)(j * 18), (float)0.0f);
                p.draw();
                GlStateManager.func_179121_F();
            }
        }
    }

    public int getSize() {
        boolean empty = false;
        int leftmost = 9;
        int rightmost = -1;
        int topmost = 9;
        int bottommost = -1;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                empty = false;
                if (i < leftmost) {
                    leftmost = i;
                }
                if (i > rightmost) {
                    rightmost = i;
                }
                if (j < topmost) {
                    topmost = j;
                }
                if (j <= bottommost) continue;
                bottommost = j;
            }
        }
        if (empty) {
            return 0;
        }
        return Math.max(rightmost - leftmost + 1, bottommost - topmost + 1);
    }

    public boolean shift(SpellParam.Side side, boolean doit) {
        boolean empty = false;
        int leftmost = 9;
        int rightmost = -1;
        int topmost = 9;
        int bottommost = -1;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece p = this.gridData[i][j];
                if (p == null) continue;
                empty = false;
                if (i < leftmost) {
                    leftmost = i;
                }
                if (i > rightmost) {
                    rightmost = i;
                }
                if (j < topmost) {
                    topmost = j;
                }
                if (j <= bottommost) continue;
                bottommost = j;
            }
        }
        if (empty) {
            return false;
        }
        if (SpellGrid.exists(leftmost + side.offx, topmost + side.offy) && SpellGrid.exists(rightmost + side.offx, bottommost + side.offy)) {
            if (!doit) {
                return true;
            }
            SpellPiece[][] newGrid = new SpellPiece[9][9];
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    SpellPiece p = this.gridData[i][j];
                    if (p == null) continue;
                    int newx = i + side.offx;
                    int newy = j + side.offy;
                    newGrid[newx][newy] = p;
                    p.x = newx;
                    p.y = newy;
                }
            }
            this.gridData = newGrid;
            return true;
        }
        return false;
    }

    public static boolean exists(int x, int y) {
        return x >= 0 && y >= 0 && x < 9 && y < 9;
    }

    public SpellPiece getPieceAtSideWithRedirections(int x, int y, SpellParam.Side side) throws SpellCompilationException {
        return this.getPieceAtSideWithRedirections(new ArrayList<SpellPiece>(), x, y, side);
    }

    public SpellPiece getPieceAtSideWithRedirections(List<SpellPiece> traversed, int x, int y, SpellParam.Side side) throws SpellCompilationException {
        SpellPiece atSide = this.getPieceAtSideSafely(x, y, side);
        if (traversed.contains(atSide)) {
            throw new SpellCompilationException("psi.spellerror.loop");
        }
        traversed.add(atSide);
        if (atSide == null || !(atSide instanceof IRedirector)) {
            return atSide;
        }
        IRedirector redirector = (IRedirector)((Object)atSide);
        SpellParam.Side rside = redirector.getRedirectionSide();
        if (!rside.isEnabled()) {
            return null;
        }
        return this.getPieceAtSideWithRedirections(traversed, atSide.x, atSide.y, rside);
    }

    public SpellPiece getPieceAtSideSafely(int x, int y, SpellParam.Side side) {
        int xp = x + side.offx;
        int yp = y + side.offy;
        if (!SpellGrid.exists(xp, yp)) {
            return null;
        }
        return this.gridData[xp][yp];
    }

    public SpellGrid(Spell spell) {
        this.spell = spell;
        this.gridData = new SpellPiece[9][9];
    }

    public boolean isEmpty() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.gridData[i][j];
                if (piece == null) continue;
                return false;
            }
        }
        return true;
    }

    public void readFromNBT(NBTTagCompound cmp) {
        this.gridData = new SpellPiece[9][9];
        NBTTagList list = cmp.func_150295_c(TAG_SPELL_LIST, 10);
        int len = list.func_74745_c();
        for (int i = 0; i < len; ++i) {
            int posY;
            int posX;
            NBTTagCompound lcmp = list.func_150305_b(i);
            if (lcmp.func_74764_b(TAG_SPELL_POS_X_LEGACY)) {
                posX = lcmp.func_74762_e(TAG_SPELL_POS_X_LEGACY);
                posY = lcmp.func_74762_e(TAG_SPELL_POS_Y_LEGACY);
            } else {
                posX = lcmp.func_74762_e(TAG_SPELL_POS_X);
                posY = lcmp.func_74762_e(TAG_SPELL_POS_Y);
            }
            NBTTagCompound data = lcmp.func_74764_b(TAG_SPELL_DATA_LEGACY) ? lcmp.func_74775_l(TAG_SPELL_DATA_LEGACY) : lcmp.func_74775_l(TAG_SPELL_DATA);
            SpellPiece piece = SpellPiece.createFromNBT(this.spell, data);
            if (piece == null) continue;
            this.gridData[posX][posY] = piece;
            piece.isInGrid = true;
            piece.x = posX;
            piece.y = posY;
        }
    }

    public void writeToNBT(NBTTagCompound cmp) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.gridData[i][j];
                if (piece == null) continue;
                NBTTagCompound lcmp = new NBTTagCompound();
                lcmp.func_74768_a(TAG_SPELL_POS_X, i);
                lcmp.func_74768_a(TAG_SPELL_POS_Y, j);
                NBTTagCompound data = new NBTTagCompound();
                piece.writeToNBT(data);
                lcmp.func_74782_a(TAG_SPELL_DATA, (NBTBase)data);
                list.func_74742_a((NBTBase)lcmp);
            }
        }
        cmp.func_74782_a(TAG_SPELL_LIST, (NBTBase)list);
    }
}

