/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.spawn;

import crazypants.enderzoo.Log;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.config.SpawnConfig;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.spawn.IBiomeFilter;
import crazypants.enderzoo.spawn.ISpawnEntry;
import crazypants.enderzoo.spawn.impl.SpawnEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public final class MobSpawns {
    private static final boolean PRINT_DETAIL = Config.spawnConfigPrintDetailedOutput;
    public static final MobSpawns instance = new MobSpawns();
    private final List<ISpawnEntry> spawnEntries = new ArrayList<ISpawnEntry>();

    private MobSpawns() {
    }

    public void loadSpawnConfig() {
        List<SpawnEntry> entries = SpawnConfig.loadSpawnConfig();
        if (entries != null) {
            Log.info("Applying " + entries.size() + " spawn entries from config.");
            for (SpawnEntry entry : entries) {
                this.addSpawn(entry);
            }
        } else {
            Log.info("No spawn entries found in config.");
        }
    }

    public void addSpawn(ISpawnEntry entry) {
        if (entry == null) {
            return;
        }
        this.spawnEntries.add(entry);
        Class clz = (Class)EntityList.field_75625_b.get(entry.getMobName());
        if (clz == null) {
            Log.warn("Skipping spawn entry " + entry.getId() + " as mob " + entry.getMobName() + " is not registered");
            return;
        }
        if (MobInfo.isDisabled(clz)) {
            Log.info(entry.getMobName() + " is disabled");
            return;
        }
        if (entry.isRemove()) {
            if (PRINT_DETAIL) {
                Log.info("EnderIO.MobSpawns.addSpawn: Removing spawns defined in entry: " + entry + " for biomes: ");
                System.out.print(" - ");
            }
            for (IBiomeFilter filter : entry.getFilters()) {
                Biome[] biomes = filter.getMatchedBiomes();
                if (PRINT_DETAIL) {
                    MobSpawns.printBiomeNames(biomes);
                }
                EntityRegistry.removeSpawn((Class)clz, (EnumCreatureType)entry.getCreatureType(), (Biome[])biomes);
            }
            if (PRINT_DETAIL) {
                System.out.println();
            }
            return;
        }
        if (PRINT_DETAIL) {
            Log.info("MobSpawns.addSpawn: Adding spawns defined in entry: " + entry + " for biomes: ");
            System.out.print(" - ");
        }
        for (IBiomeFilter filter : entry.getFilters()) {
            Biome[] biomes = filter.getMatchedBiomes();
            if (PRINT_DETAIL) {
                MobSpawns.printBiomeNames(biomes);
            }
            EntityRegistry.addSpawn((Class)clz, (int)entry.getRate(), (int)entry.getMinGroupSize(), (int)entry.getMaxGroupSize(), (EnumCreatureType)entry.getCreatureType(), (Biome[])biomes);
        }
        if (PRINT_DETAIL) {
            System.out.println();
        }
    }

    protected static void printBiomeNames(Biome[] biomes) {
        for (Biome biome : biomes) {
            if (biome != null) {
                System.out.print(biome.func_185359_l() + ", ");
                continue;
            }
            System.out.print("null, ");
        }
    }

    public Collection<ISpawnEntry> getEntries() {
        return this.spawnEntries;
    }
}

