/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.hermitquest.HQConfig;
import zairus.hermitquest.HermitQuest;
import zairus.hermitquest.client.renderer.RenderFactory;
import zairus.hermitquest.client.renderer.entity.RenderDiabloElPollo;
import zairus.hermitquest.client.renderer.entity.RenderDioriteArrow;
import zairus.hermitquest.client.renderer.entity.RenderHermitBoss;
import zairus.hermitquest.client.renderer.entity.RenderImpFireball;
import zairus.hermitquest.client.renderer.entity.RenderIskallBeam;
import zairus.hermitquest.client.renderer.entity.RenderJevinSlime;
import zairus.hermitquest.client.renderer.entity.RenderLadyZombie;
import zairus.hermitquest.client.renderer.entity.RenderSmallSnake;
import zairus.hermitquest.client.renderer.entity.RenderThrowableBook;
import zairus.hermitquest.client.renderer.entity.RenderThrowableGoldenApple;
import zairus.hermitquest.client.renderer.entity.RenderThrowableTorch;
import zairus.hermitquest.entity.EntityAngryVillager;
import zairus.hermitquest.entity.EntityDiabloElPollo;
import zairus.hermitquest.entity.EntityJevinSlime;
import zairus.hermitquest.entity.EntityLadyZombie;
import zairus.hermitquest.entity.EntitySmallSnake;
import zairus.hermitquest.entity.boss.EntityHermitBoss;
import zairus.hermitquest.entity.projectile.EntityDioriteArrow;
import zairus.hermitquest.entity.projectile.EntityImpFireball;
import zairus.hermitquest.entity.projectile.EntityIskallBeam;
import zairus.hermitquest.entity.projectile.EntityThrowableBook;
import zairus.hermitquest.entity.projectile.EntityThrowableGoldenApple;
import zairus.hermitquest.entity.projectile.EntityThrowableTorch;

public class HQEntities {
    private static int lastEntityId = -1;

    public static void registerAll() {
        HQEntities.registerEntity(EntityHermitBoss.class, "hermitboss", 160, 1, true, 0, 0xFFFFFF);
        HQEntities.registerEntity(EntityDiabloElPollo.class, "diabloelpollo", 160, 1, true, 0, 0);
        HQEntities.registerEntity(EntityJevinSlime.class, "jevinslime", 160, 1, true, 5268386, 7242958);
        HQEntities.registerEntity(EntityLadyZombie.class, "lady_zombie", 160, 1, true, 3827758, 14564217);
        HQEntities.registerEntity(EntityAngryVillager.class, "angry_villager", 160, 1, true, 11772549, 15589320);
        HQEntities.registerEntity(EntitySmallSnake.class, "small_snake", 160, 1, true, 9782796, 16296303);
        HQEntities.registerEntity(EntityIskallBeam.class, "iskallbeam", 160, 1, true);
        HQEntities.registerEntity(EntityDioriteArrow.class, "dioritearrow", 160, 1, true);
        HQEntities.registerEntity(EntityImpFireball.class, "impfireball", 160, 1, true);
        HQEntities.registerEntity(EntityThrowableGoldenApple.class, "throwableGoldenApple", 160, 1, true);
        HQEntities.registerEntity(EntityThrowableBook.class, "throwableBook", 160, 1, true);
        HQEntities.registerEntity(EntityThrowableTorch.class, "throwableTorch", 160, 1, true);
        if (HQConfig.spawn_diablo) {
            EntityRegistry.addSpawn(EntityDiabloElPollo.class, (int)5, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        }
        if (HQConfig.spawn_swampsnake) {
            EntityRegistry.addSpawn(EntitySmallSnake.class, (int)5, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76780_h});
        }
        EntityRegistry.addSpawn(EntityLadyZombie.class, (int)5, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        for (Biome biome : Biome.field_185377_q) {
            if (biome == Biomes.field_76789_p || biome == Biomes.field_76788_q || biome == Biomes.field_76779_k) continue;
            EntityRegistry.addSpawn(EntityJevinSlime.class, (int)20, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
        }
    }

    public static void registerEntity(Class<? extends Entity> clazz, String name, int range, int frequency, boolean velocityUpdates) {
        EntityRegistry.registerModEntity(clazz, (String)name, (int)HQEntities.getNextEntityId(), (Object)HermitQuest.instance, (int)range, (int)frequency, (boolean)velocityUpdates);
    }

    public static void registerEntity(Class<? extends Entity> clazz, String name, int range, int frequency, boolean velocityUpdates, int primaryColor, int secondaryColor) {
        HQEntities.registerEntity(clazz, name, range, frequency, velocityUpdates);
        EntityRegistry.registerEgg(clazz, (int)primaryColor, (int)secondaryColor);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityHermitBoss.class, RenderFactory.create(RenderHermitBoss.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityDiabloElPollo.class, RenderFactory.create(RenderDiabloElPollo.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityJevinSlime.class, RenderFactory.create(RenderJevinSlime.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityLadyZombie.class, RenderFactory.create(RenderLadyZombie.class));
        RenderingRegistry.registerEntityRenderingHandler(EntitySmallSnake.class, RenderFactory.create(RenderSmallSnake.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityIskallBeam.class, RenderFactory.createR2(RenderIskallBeam.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityDioriteArrow.class, RenderFactory.createR2(RenderDioriteArrow.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityImpFireball.class, RenderFactory.createR2(RenderImpFireball.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowableGoldenApple.class, RenderFactory.createR2(RenderThrowableGoldenApple.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowableBook.class, RenderFactory.createR2(RenderThrowableBook.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowableTorch.class, RenderFactory.createR2(RenderThrowableTorch.class));
    }

    public static int getNextEntityId() {
        return ++lastEntityId;
    }
}

