/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.biome.decorate;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import zairus.hermitquest.biome.decorate.WorldGenDecorationBase;
import zairus.hermitquest.block.HQBlocks;

public class WorldGenWelsHelm
extends WorldGenDecorationBase {
    private static final BlockStateMatcher IS_SAND = BlockStateMatcher.func_177638_a((Block)Blocks.field_150354_m).func_177637_a((IProperty)BlockSand.field_176504_a, Predicates.equalTo((Object)BlockSand.EnumType.SAND));
    private final IBlockState sandSlab = Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SAND).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
    private final IBlockState sandstone = Blocks.field_150322_A.func_176223_P();
    private final IBlockState water = Blocks.field_150358_i.func_176223_P();

    @Override
    public List<Biome> getAllowedBiomes() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        biomes.add(Biomes.field_76769_d);
        biomes.add(Biomes.field_76786_s);
        biomes.add(Biomes.field_185442_R);
        return biomes;
    }

    @Override
    protected boolean doGenerate(World world, Random rand, BlockPos pos) {
        if (rand.nextInt(this.rarity) != 0) {
            return false;
        }
        while (world.func_175623_d(pos) && pos.func_177956_o() > 2) {
            pos = pos.func_177977_b();
        }
        if (!IS_SAND.apply(world.func_180495_p(pos))) {
            return false;
        }
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (!world.func_175623_d(pos.func_177982_a(i, -1, j)) || !world.func_175623_d(pos.func_177982_a(i, -2, j))) continue;
                return false;
            }
        }
        for (int l = -1; l <= 0; ++l) {
            for (int l1 = -2; l1 <= 2; ++l1) {
                for (int k = -2; k <= 2; ++k) {
                    world.func_180501_a(pos.func_177982_a(l1, l, k), this.sandstone, 2);
                }
            }
        }
        world.func_180501_a(pos, this.water, 2);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            world.func_180501_a(pos.func_177972_a(enumfacing), this.water, 2);
        }
        for (int i1 = -2; i1 <= 2; ++i1) {
            for (int i2 = -2; i2 <= 2; ++i2) {
                if (i1 != -2 && i1 != 2 && i2 != -2 && i2 != 2) continue;
                world.func_180501_a(pos.func_177982_a(i1, 1, i2), this.sandstone, 2);
            }
        }
        world.func_180501_a(pos.func_177982_a(2, 1, 0), this.sandSlab, 2);
        world.func_180501_a(pos.func_177982_a(-2, 1, 0), this.sandSlab, 2);
        world.func_180501_a(pos.func_177982_a(0, 1, 2), this.sandSlab, 2);
        world.func_180501_a(pos.func_177982_a(0, 1, -2), this.sandSlab, 2);
        for (int j1 = -1; j1 <= 1; ++j1) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                if (j1 == 0 && j2 == 0) {
                    world.func_180501_a(pos.func_177982_a(j1, 4, j2), this.sandstone, 2);
                    continue;
                }
                world.func_180501_a(pos.func_177982_a(j1, 4, j2), this.sandSlab, 2);
            }
        }
        for (int k1 = 1; k1 <= 3; ++k1) {
            world.func_180501_a(pos.func_177982_a(-1, k1, -1), this.sandstone, 2);
            world.func_180501_a(pos.func_177982_a(-1, k1, 1), this.sandstone, 2);
            world.func_180501_a(pos.func_177982_a(1, k1, -1), this.sandstone, 2);
            world.func_180501_a(pos.func_177982_a(1, k1, 1), this.sandstone, 2);
        }
        world.func_180501_a(pos.func_177977_b(), HQBlocks.HELMET_IN_STONE.func_176223_P(), 2);
        return true;
    }
}

