/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.spectre;

import java.util.ArrayList;
import java.util.UUID;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.handler.spectre.SpectreHandler;
import lumien.randomthings.item.ItemPositionFilter;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.util.NBTUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpectreCube
implements IInventoryChangedListener {
    UUID owner;
    ArrayList<UUID> guests;
    int height;
    int position;
    SpectreHandler handler;
    InventoryBasic cubeInventory = new InventoryBasic("SpectreCube", false, 11);
    BlockPos spawnBlock;

    public SpectreCube(SpectreHandler handler) {
        this.guests = new ArrayList();
        this.handler = handler;
        this.height = 2;
        this.cubeInventory.func_110134_a((IInventoryChangedListener)this);
    }

    public SpectreCube(SpectreHandler handler, UUID owner, int position) {
        this(handler);
        this.owner = owner;
        this.position = position;
        this.spawnBlock = new BlockPos(position * 16 + 8, 0, 8);
    }

    public InventoryBasic getInventory() {
        return this.cubeInventory;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("owner", this.owner.toString());
        compound.func_74768_a("position", this.position);
        NBTTagList guestTagList = new NBTTagList();
        for (UUID uuid : this.guests) {
            guestTagList.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        compound.func_74782_a("guests", (NBTBase)guestTagList);
        compound.func_74768_a("height", this.height);
        NBTUtil.writeBlockPosToNBT(compound, "spawnBlock", this.spawnBlock);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.owner = UUID.fromString(compound.func_74779_i("owner"));
        this.position = compound.func_74762_e("position");
        NBTTagList guestTagList = compound.func_150295_c("guestTagList", 8);
        for (int i = 0; i < guestTagList.func_74745_c(); ++i) {
            NBTTagString uuidString = (NBTTagString)guestTagList.func_179238_g(i);
            this.guests.add(UUID.fromString(uuidString.func_150285_a_()));
        }
        this.height = compound.func_74762_e("height");
        this.spawnBlock = NBTUtil.readBlockPosFromNBT(compound, "spawnBlock");
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void generate(World worldObj) {
        BlockPos corner;
        BlockPos pos1 = corner = new BlockPos(this.position * 16, 0, 0);
        BlockPos pos2 = corner.func_177982_a(15, this.height + 1, 15);
        SpectreCube.generateCube(worldObj, pos1, pos2, ModBlocks.spectreBlock.func_176223_P(), 3);
        SpectreCube.generateCube(worldObj, pos1.func_177982_a(7, 0, 7), pos1.func_177982_a(8, 0, 8), ModBlocks.spectreCore.func_176223_P(), 3);
    }

    public int increaseHeight(int amount) {
        int heightLeft = 255 - (this.height + 1);
        int difference = heightLeft - amount;
        int newHeight = this.height;
        if (difference > 0) {
            newHeight = this.height + amount;
        } else if (difference <= 0) {
            newHeight = this.height + heightLeft;
        }
        int change = newHeight - this.height;
        if (newHeight != this.height) {
            this.changeHeight(this.handler.getWorld(), newHeight);
        }
        return change;
    }

    private void changeHeight(World worldObj, int newHeight) {
        BlockPos corner;
        BlockPos pos1 = corner = new BlockPos(this.position * 16, 0, 0);
        BlockPos pos2 = corner.func_177982_a(15, this.height + 1, 15);
        SpectreCube.generateCube(worldObj, pos1, pos2, Blocks.field_150350_a.func_176223_P(), 2);
        this.height = newHeight;
        this.generate(worldObj);
        this.handler.func_76185_a();
    }

    public BlockPos getSpawnBlock() {
        return this.spawnBlock;
    }

    private static void generateCube(World worldObj, BlockPos pos1, BlockPos pos2, IBlockState state, int flag) {
        int minX = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        int minY = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        int minZ = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        int maxX = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
        int maxY = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
        int maxZ = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && y != minY && z != minZ && x != maxX && y != maxY && z != maxZ) continue;
                    worldObj.func_180501_a(new BlockPos(x, y, z), state, flag);
                }
            }
        }
    }

    public void func_76316_a(InventoryBasic inventory) {
        ItemStack spawnPosStack = inventory.func_70301_a(0);
        this.spawnBlock = spawnPosStack == null || spawnPosStack.func_77973_b() != ModItems.positionFilter ? new BlockPos(this.position * 16 + 8, 0, 8) : ItemPositionFilter.getPosition(spawnPosStack);
        this.handler.func_76185_a();
    }
}

