/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.entitys;

import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityProjectedItem
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Optional<ItemStack>> ITEM = EntityDataManager.func_187226_a(EntityProjectedItem.class, (DataSerializer)DataSerializers.field_187196_f);
    private int age;
    private int health = 5;
    public float hoverStart;
    EnumFacing direction = EnumFacing.NORTH;
    boolean canBePickedUp = false;
    boolean enterInventories = true;
    public int lifespan = 1200;

    public EntityProjectedItem(World worldIn, double x, double y, double z) {
        super(worldIn);
        this.hoverStart = (float)(Math.random() * Math.PI * 2.0);
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
    }

    public EntityProjectedItem(World worldIn, double x, double y, double z, ItemStack stack, EnumFacing facing) {
        this(worldIn, x, y, z);
        this.setEntityItemStack(stack);
        this.lifespan = 1200;
        this.direction = facing;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public EntityProjectedItem(World worldIn) {
        super(worldIn);
        this.hoverStart = (float)(Math.random() * Math.PI * 2.0);
        this.func_70105_a(0.25f, 0.25f);
        this.setEntityItemStack(new ItemStack(Blocks.field_150350_a, 0));
    }

    public void setPickup(boolean canBePickedUp) {
        this.canBePickedUp = canBePickedUp;
    }

    public void setEnterInventories(boolean enterInventories) {
        this.enterInventories = enterInventories;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)Optional.absent());
    }

    public void func_70071_h_() {
        if (this.getEntityItem() == null) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
            if (this.field_70145_X) {
                this.dropAsItem();
            }
            this.field_70159_w = (double)this.direction.func_82601_c() / 10.0;
            this.field_70181_x = (double)this.direction.func_96559_d() / 10.0;
            this.field_70179_y = (double)this.direction.func_82599_e() / 10.0;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70159_w == 0.0 && this.field_70181_x == 0.0 && this.field_70179_y == 0.0 && !this.field_70170_p.field_72995_K) {
                if (this.enterInventories) {
                    TileEntity nextTileEntity = this.field_70170_p.func_175625_s(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_177972_a(this.direction));
                    if (this.getEntityItem() != null && this.getEntityItem().field_77994_a > 0 && nextTileEntity != null && nextTileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.direction.func_176734_d())) {
                        IItemHandler itemHandler = (IItemHandler)nextTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.direction.func_176734_d());
                        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)this.getEntityItem(), (boolean)false);
                        if (remaining != null && remaining.field_77994_a > 0) {
                            this.dropAsItem();
                        } else {
                            this.func_70106_y();
                        }
                    }
                } else {
                    this.dropAsItem();
                }
            }
            float f = 0.98f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.98f;
            }
            if (this.age != Short.MIN_VALUE) {
                ++this.age;
            }
            ItemStack item = (ItemStack)((Optional)this.func_184212_Q().func_187225_a(ITEM)).orNull();
            if (!this.field_70170_p.field_72995_K && this.age >= this.lifespan) {
                this.func_70106_y();
                this.dropAsItem();
            }
            if (item != null && item.field_77994_a <= 0) {
                this.func_70106_y();
            }
        }
    }

    private void dropAsItem() {
        if (this.getEntityItem() != null && this.getEntityItem().field_77994_a > 0) {
            EntityItem ei = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getEntityItem());
            this.field_70170_p.func_72838_d((Entity)ei);
            ei.lifespan = 1200;
        }
        this.func_70106_y();
    }

    public void setLifeSpan(int newLifespawn) {
        this.lifespan = newLifespawn;
    }

    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        this.health = (int)((float)this.health - amount);
        if (this.health <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Health", (short)this.health);
        compound.func_74777_a("Age", (short)this.age);
        compound.func_74768_a("Lifespan", this.lifespan);
        compound.func_74768_a("direction", this.direction.ordinal());
        compound.func_74757_a("canBePickedUp", this.canBePickedUp);
        if (this.getEntityItem() != null) {
            compound.func_74782_a("Item", (NBTBase)this.getEntityItem().func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.health = compound.func_74765_d("Health");
        this.age = compound.func_74765_d("Age");
        this.direction = EnumFacing.values()[compound.func_74762_e("direction")];
        this.canBePickedUp = compound.func_74767_n("canBePickedUp");
        NBTTagCompound nbttagcompound = compound.func_74775_l("Item");
        this.setEntityItemStack(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
        ItemStack item = (ItemStack)((Optional)this.func_184212_Q().func_187225_a(ITEM)).orNull();
        if (item == null || item.field_77994_a <= 0) {
            this.func_70106_y();
        }
        if (compound.func_74764_b("Lifespan")) {
            this.lifespan = compound.func_74762_e("Lifespan");
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.canBePickedUp) {
            ItemStack itemstack = this.getEntityItem();
            int i = itemstack.field_77994_a;
            if (i <= 0 || entityIn.field_71071_by.func_70441_a(itemstack)) {
                if (!this.func_174814_R()) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                entityIn.func_71001_a((Entity)this, i);
                if (!this.field_70170_p.field_72995_K) {
                    EntityTracker entitytracker = ((WorldServer)this.field_70170_p).func_73039_n();
                    entitytracker.func_151247_a((Entity)this, (Packet)new SPacketCollectItem(this.func_145782_y(), entityIn.func_145782_y()));
                }
                if (itemstack.field_77994_a <= 0) {
                    this.func_70106_y();
                }
                entityIn.func_71064_a(StatList.func_188056_d((Item)itemstack.func_77973_b()), i);
            }
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.func_95999_t() : I18n.func_74838_a((String)("item." + this.getEntityItem().func_77977_a()));
    }

    public boolean func_70075_an() {
        return false;
    }

    @Nullable
    public Entity func_184204_a(int dimensionIn) {
        Entity entity = super.func_184204_a(dimensionIn);
        return entity;
    }

    public ItemStack getEntityItem() {
        ItemStack itemstack = (ItemStack)((Optional)this.func_184212_Q().func_187225_a(ITEM)).orNull();
        if (itemstack == null) {
            return new ItemStack(Blocks.field_150348_b);
        }
        return itemstack;
    }

    public void setEntityItemStack(@Nullable ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)Optional.fromNullable((Object)stack));
        this.func_184212_Q().func_187217_b(ITEM);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAge() {
        return this.age;
    }

    public void setNoDespawn() {
        this.age = -6000;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.direction.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.direction = EnumFacing.values()[additionalData.readInt()];
    }
}

