/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import jeresources.api.render.ColourHelper;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.MobRegistryImpl;
import jeresources.reference.Resources;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static void drawArrow(double xBegin, double yBegin, double xEnd, double yEnd, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = new ScaledResolution(mc).func_78325_e();
        GlStateManager.func_179124_c((float)ColourHelper.getRed(color), (float)ColourHelper.getGreen(color), (float)ColourHelper.getBlue(color));
        GL11.glLineWidth((float)((float)scale * 1.3f));
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)xBegin, (double)yBegin);
        GL11.glVertex2d((double)xEnd, (double)yEnd);
        GL11.glEnd();
        double angle = Math.atan2(yEnd - yBegin, xEnd - xBegin) * 180.0 / Math.PI;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)xEnd, (double)yEnd, (double)0.0);
        GlStateManager.func_179114_b((float)((float)angle), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)3.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)-1.5);
        GL11.glVertex2d((double)0.0, (double)1.5);
        GL11.glEnd();
        GlStateManager.func_179121_F();
    }

    public static void drawLine(double xBegin, double yBegin, double xEnd, double yEnd, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = new ScaledResolution(mc).func_78325_e();
        GlStateManager.func_179124_c((float)ColourHelper.getRed(color), (float)ColourHelper.getGreen(color), (float)ColourHelper.getBlue(color));
        GL11.glLineWidth((float)((float)scale * 1.3f));
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)xBegin, (double)yBegin);
        GL11.glVertex2d((double)xEnd, (double)yEnd);
        GL11.glEnd();
    }

    public static void drawPoint(double x, double y, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = new ScaledResolution(mc).func_78325_e();
        GlStateManager.func_179124_c((float)ColourHelper.getRed(color), (float)ColourHelper.getGreen(color), (float)ColourHelper.getBlue(color));
        GL11.glPointSize((float)((float)scale * 1.3f));
        GL11.glBegin((int)0);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glEnd();
    }

    public static void renderEntity(int x, int y, float scale, float yaw, float pitch, EntityLivingBase entityLivingBase) {
        if (entityLivingBase.field_70170_p == null) {
            entityLivingBase.field_70170_p = Minecraft.func_71410_x().field_71441_e;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float renderYawOffset = entityLivingBase.field_70761_aq;
        float rotationYaw = entityLivingBase.field_70177_z;
        float rotationPitch = entityLivingBase.field_70125_A;
        float prevRotationYawHead = entityLivingBase.field_70758_at;
        float rotationYawHead = entityLivingBase.field_70759_as;
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(entityLivingBase, new IMobRenderHook.RenderInfo(x, y, scale, yaw, pitch));
        x = renderInfo.x;
        y = renderInfo.y;
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        GlStateManager.func_179114_b((float)(-((float)Math.atan(pitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entityLivingBase.field_70761_aq = (float)Math.atan(yaw / 40.0f) * 20.0f;
        entityLivingBase.field_70177_z = (float)Math.atan(yaw / 40.0f) * 40.0f;
        entityLivingBase.field_70125_A = -((float)Math.atan(pitch / 40.0f)) * 20.0f;
        entityLivingBase.field_70759_as = entityLivingBase.field_70177_z;
        entityLivingBase.field_70758_at = entityLivingBase.field_70177_z;
        GlStateManager.func_179137_b((double)0.0, (double)entityLivingBase.func_70033_W(), (double)0.0);
        RenderHelper.getRenderManager().func_178631_a(180.0f);
        RenderHelper.getRenderManager().func_188391_a((Entity)entityLivingBase, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        entityLivingBase.field_70761_aq = renderYawOffset;
        entityLivingBase.field_70177_z = rotationYaw;
        entityLivingBase.field_70125_A = rotationPitch;
        entityLivingBase.field_70758_at = prevRotationYawHead;
        entityLivingBase.field_70759_as = rotationYawHead;
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void renderChest(float x, float y, float rotate, float scale, float lidAngle) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.Vanilla.CHEST);
        ModelChest modelchest = new ModelChest();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179114_b((float)-160.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)(-scale));
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)rotate, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
        modelchest.field_78234_a.field_78795_f = -(lidAngleF * (float)Math.PI / 2.0f);
        modelchest.field_78233_c.field_82906_o += 0.1f;
        modelchest.field_78233_c.field_82907_q += 0.12f;
        modelchest.field_78232_b.field_82906_o -= 0.755f;
        modelchest.field_78232_b.field_82908_p -= 0.4f;
        modelchest.field_78232_b.field_82907_q -= 0.9f;
        modelchest.func_78231_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    public static void renderBlock(IBlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)(50.0f + z));
        GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(scale *= 50.0f), (float)(-scale), (float)(-scale));
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)rotate, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_175602_ab().func_175016_a(block, 1.0f);
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    public static void scissor(Minecraft mc, int guiWidth, int guiHeight, float x, float y, float w, float h) {
        int scale = new ScaledResolution(mc).func_78325_e();
        x *= (float)scale;
        y *= (float)scale;
        w *= (float)scale;
        h *= (float)scale;
        float guiScaledWidth = guiWidth * scale;
        float guiScaledHeight = guiHeight * scale;
        long guiLeft = Math.round(((float)mc.field_71443_c - guiScaledWidth) / 2.0f);
        long guiTop = Math.round(((float)mc.field_71440_d + guiScaledHeight) / 2.0f);
        int scissorX = Math.round((float)guiLeft + x - (float)scale);
        int scissorY = Math.round((float)guiTop - h - y);
        int scissorW = Math.round(w);
        int scissorH = Math.round(h);
        IScissorHook.ScissorInfo scissorInfo = MobRegistryImpl.applyScissorHooks(new IScissorHook.ScissorInfo(scissorX, scissorY, scissorW, scissorH));
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorInfo.x, (int)scissorInfo.y, (int)scissorInfo.width, (int)scissorInfo.height);
    }

    public static void stopScissor() {
        GL11.glDisable((int)3089);
    }

    public static void drawTexture(int x, int y, int u, int v, int width, int height, ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        GuiUtils.drawTexturedModalRect((int)x, (int)y, (int)u, (int)v, (int)width, (int)height, (float)0.0f);
    }

    private static RenderManager getRenderManager() {
        return Minecraft.func_71410_x().func_175598_ae();
    }
}

