/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.Restriction;
import jeresources.entry.WorldGenEntry;
import jeresources.util.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class MapKeys {
    private static final Cache<IBlockState, String> keyCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();

    @Nullable
    public static String getKey(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Block block = state.func_177230_c();
        if (!block.hasTileEntity(state)) {
            try {
                return (String)keyCache.get((Object)state, () -> MapKeys.getKeyUncached(block, state, target, world, pos, player));
            }
            catch (ExecutionException e) {
                LogHelper.error("Cache error", e);
            }
        }
        return MapKeys.getKeyUncached(block, state, target, world, pos, player);
    }

    @Nullable
    private static String getKeyUncached(Block block, IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = block.func_176201_c(state);
        ItemStack pickBlock = null;
        try {
            pickBlock = block.getPickBlock(state, target, world, pos, player);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (pickBlock == null || pickBlock.func_77973_b() == null) {
            return block.getRegistryName().toString() + ':' + meta;
        }
        return MapKeys.getKey(pickBlock);
    }

    @Nullable
    public static String getKey(ItemStack drop) {
        if (drop == null) {
            return null;
        }
        Item item = drop.func_77973_b();
        if (item == null) {
            return null;
        }
        String registryName = item.getRegistryName().toString();
        StringBuilder key = new StringBuilder(registryName);
        key.append(":").append(drop.func_77960_j());
        if (drop.func_77978_p() != null) {
            key.append(":").append(drop.func_77978_p());
        }
        return key.toString();
    }

    public static String getKey(IPlantable plant) {
        return plant.getPlant(null, null).func_177230_c().func_149739_a();
    }

    public static String getKey(LootDrop dropItem) {
        return MapKeys.getKey(dropItem.item);
    }

    public static String getKey(ItemStack drop, Restriction restriction) {
        return MapKeys.getKey(drop) + ":" + restriction.toString();
    }

    public static String getKey(WorldGenEntry entry) {
        return MapKeys.getKey(entry.getBlock(), entry.getRestriction());
    }
}

