/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import jeresources.config.ConfigHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;

public class ProfilingTimer {
    private final ICommandSender sender;
    private int totalChunks;
    private final Map<Integer, DimensionCounters> dimensionsMap = new HashMap<Integer, DimensionCounters>();

    public ProfilingTimer(ICommandSender sender, int chunkCount) {
        this.sender = sender;
        this.totalChunks = chunkCount;
    }

    public void startChunk(int dim) {
        DimensionCounters counters = this.dimensionsMap.get(dim);
        if (counters == null) {
            counters = new DimensionCounters();
            this.dimensionsMap.put(dim, counters);
            this.send("[" + DimensionManager.getProvider((int)dim).func_186058_p().func_186065_b() + "] Started profiling");
        }
        ++counters.threadCounter;
    }

    public void endChunk(int dim) {
        DimensionCounters counters = this.dimensionsMap.get(dim);
        --counters.threadCounter;
        if (++counters.chunkCounter % 100 == 0) {
            this.sendSpeed(dim);
        }
        if (this.totalChunks == counters.chunkCounter) {
            counters.completed = true;
        }
    }

    public void complete() {
        for (int dim : this.dimensionsMap.keySet()) {
            DimensionCounters counters = this.dimensionsMap.get(dim);
            counters.completed = true;
            this.send("[" + DimensionManager.getProvider((int)dim).func_186058_p().func_186065_b() + "] Completed profiling of " + this.getBlocksPerLayer(dim) * 256L + " blocks in " + (System.currentTimeMillis() - counters.start) + " ms saved to " + ConfigHandler.getWorldGenFile());
        }
    }

    public synchronized boolean isCompleted() {
        for (DimensionCounters counters : this.dimensionsMap.values()) {
            if (counters.completed) continue;
            return false;
        }
        return true;
    }

    private void send(String s) {
        this.sender.func_145747_a((ITextComponent)new TextComponentTranslation(s, new Object[0]));
    }

    private void sendSpeed(int dim) {
        DimensionCounters counters = this.dimensionsMap.get(dim);
        float time = (float)(System.currentTimeMillis() - counters.start) * 1.0f / (float)counters.chunkCounter;
        String message = "[" + DimensionManager.getProvider((int)dim).func_186058_p().func_186065_b() + "] Scanned " + counters.chunkCounter + " chunks at " + String.format("%3.2f", Float.valueOf(time)) + " ms/chunk";
        this.send(message);
    }

    public long getBlocksPerLayer(int dim) {
        DimensionCounters counters = this.dimensionsMap.get(dim);
        return counters.chunkCounter * 16 * 16;
    }

    private static class DimensionCounters {
        public final long start = System.currentTimeMillis();
        public int chunkCounter;
        public int threadCounter;
        public boolean completed;

        private DimensionCounters() {
        }
    }
}

