/*
 * Decompiled with CFR 0.152.
 */
package jeresources.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionCustom;
import jeresources.api.distributions.DistributionHelpers;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.config.ConfigHandler;
import jeresources.entry.WorldGenEntry;
import jeresources.registry.WorldGenRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class WorldGenAdapter {
    private static Map<String, Restriction> map = new HashMap<String, Restriction>();

    public static boolean hasWorldGenDIYData() {
        return ConfigHandler.getWorldGenFile().exists();
    }

    public static boolean readDIYData() {
        JsonParser parser = new JsonParser();
        try {
            JsonElement base = parser.parse((Reader)new FileReader(ConfigHandler.getWorldGenFile()));
            if (!base.isJsonArray() || base.getAsJsonArray().size() == 0) {
                return false;
            }
            JsonArray array = base.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                JsonElement element = obj.get("mod");
                if (element != null && !Loader.isModLoaded((String)element.getAsString())) continue;
                String block = obj.get("block").getAsString();
                JsonElement distribElement = obj.get("distrib");
                if (distribElement == null) continue;
                String distrib = distribElement.getAsString();
                JsonElement silk = obj.get("silktouch");
                boolean silktouch = silk != null && silk.getAsBoolean();
                JsonElement dimElement = obj.get("dim");
                String dim = dimElement != null ? dimElement.getAsString() : "";
                String[] blockParts = block.split(":");
                Block blockBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockParts[0], blockParts[1]));
                if (blockBlock == null || Item.func_150898_a((Block)blockBlock) == null) continue;
                int oreMeta = blockParts.length == 3 ? Integer.parseInt(blockParts[2]) : 0;
                ItemStack blockStack = new ItemStack(blockBlock, 1, oreMeta);
                ArrayList<DistributionHelpers.OrePoint> points = new ArrayList<DistributionHelpers.OrePoint>();
                for (String point : distrib.split(";")) {
                    String[] split = point.split(",");
                    if (split.length != 2) continue;
                    points.add(new DistributionHelpers.OrePoint(Integer.parseInt(split[0]), Float.parseFloat(split[1])));
                }
                DistributionCustom distribution = new DistributionCustom(DistributionHelpers.getDistributionFromPoints(points.toArray(new DistributionHelpers.OrePoint[points.size()])));
                JsonElement dropsListElement = obj.get("dropsList");
                ArrayList<LootDrop> dropList = new ArrayList<LootDrop>();
                if (dropsListElement != null) {
                    JsonArray drops = dropsListElement.getAsJsonArray();
                    for (JsonElement dropElement : drops) {
                        JsonElement fortuneElement;
                        String itemStackString;
                        String[] stackStrings;
                        Item item;
                        JsonObject drop = dropElement.getAsJsonObject();
                        JsonElement itemStackElement = drop.get("itemStack");
                        if (itemStackElement.isJsonNull() || (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((stackStrings = (itemStackString = itemStackElement.getAsString()).split(":", 4))[0], stackStrings[1]))) == null) continue;
                        ItemStack itemStack = new ItemStack(item);
                        if (stackStrings.length >= 3) {
                            itemStack.func_77964_b(Integer.valueOf(stackStrings[2]).intValue());
                        }
                        if (stackStrings.length == 4) {
                            try {
                                itemStack.func_77982_d(JsonToNBT.func_180713_a((String)stackStrings[3]));
                            }
                            catch (NBTException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((fortuneElement = drop.get("fortunes")) == null) continue;
                        JsonObject fortunes = fortuneElement.getAsJsonObject();
                        for (Map.Entry fortuneValue : fortunes.entrySet()) {
                            int fortuneLevel = Integer.valueOf((String)fortuneValue.getKey());
                            float dropAmount = ((JsonElement)fortuneValue.getValue()).getAsFloat();
                            dropList.add(new LootDrop(itemStack, dropAmount, fortuneLevel));
                        }
                    }
                }
                WorldGenRegistry.getInstance().registerEntry(new WorldGenEntry(blockStack, (DistributionBase)distribution, WorldGenAdapter.getRestriction(dim), silktouch, dropList.toArray(new LootDrop[dropList.size()])));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        map.clear();
        return true;
    }

    private static Restriction getRestriction(String dim) {
        return map.computeIfAbsent(dim, k -> new Restriction(new DimensionRestriction(dim)));
    }
}

