/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.mob;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeresources.config.Settings;
import jeresources.jei.JEIConfig;
import jeresources.jei.mob.MobWrapper;
import jeresources.reference.Resources;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;

public class MobCategory
extends BlankRecipeCategory<MobWrapper> {
    protected static final int X_FIRST_ITEM = 97;
    protected static final int Y_FIRST_ITEM = 43;
    protected static int SPACING_X = 72 / Settings.ITEMS_PER_ROW;
    protected static int SPACING_Y = 80 / Settings.ITEMS_PER_COLUMN;
    private IDrawable icon = JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 16, 16, 16, 16);

    @Nonnull
    public String getUid() {
        return "jeresources.mob";
    }

    @Nonnull
    public String getTitle() {
        return TranslationHelper.translateToLocal("jer.mob.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.MOB;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull MobWrapper recipeWrapper) {
        int i;
        int xOffset = 0;
        int slot = 0;
        for (i = 0; i < Settings.ITEMS_PER_ROW; ++i) {
            int yOffset = 0;
            for (int ii = 0; ii < Settings.ITEMS_PER_COLUMN; ++ii) {
                recipeLayout.getItemStacks().init(slot++, false, 97 + xOffset, 43 + yOffset);
                yOffset += SPACING_Y;
            }
            xOffset += SPACING_X;
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        for (i = 0; i < Math.min(recipeWrapper.getDrops().length, Settings.ITEMS_PER_ROW * Settings.ITEMS_PER_COLUMN); ++i) {
            recipeLayout.getItemStacks().set(i, recipeWrapper.getDrops()[i].getDrops());
        }
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull MobWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int i;
        int xOffset = 0;
        int slot = 0;
        for (i = 0; i < Settings.ITEMS_PER_ROW; ++i) {
            int yOffset = 0;
            for (int ii = 0; ii < Settings.ITEMS_PER_COLUMN; ++ii) {
                recipeLayout.getItemStacks().init(slot++, false, 97 + xOffset, 43 + yOffset);
                yOffset += SPACING_Y;
            }
            xOffset += SPACING_X;
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        for (i = 0; i < Math.min(recipeWrapper.getDrops().length, Settings.ITEMS_PER_ROW * Settings.ITEMS_PER_COLUMN); ++i) {
            recipeLayout.getItemStacks().set(i, recipeWrapper.getDrops()[i].getDrops());
        }
    }
}

