/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu.gui;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import lumien.custommainmenu.CustomMainMenu;
import lumien.custommainmenu.configuration.Alignment;
import lumien.custommainmenu.configuration.Config;
import lumien.custommainmenu.configuration.GuiConfig;
import lumien.custommainmenu.configuration.elements.Background;
import lumien.custommainmenu.configuration.elements.Button;
import lumien.custommainmenu.configuration.elements.Image;
import lumien.custommainmenu.configuration.elements.Label;
import lumien.custommainmenu.configuration.elements.Panorama;
import lumien.custommainmenu.configuration.elements.SplashText;
import lumien.custommainmenu.gui.GuiCustomButton;
import lumien.custommainmenu.gui.GuiCustomLabel;
import lumien.custommainmenu.gui.GuiCustomWrappedButton;
import lumien.custommainmenu.gui.GuiFakeMain;
import lumien.custommainmenu.lib.MODE;
import lumien.custommainmenu.lib.actions.ActionOpenLink;
import lumien.custommainmenu.lib.textures.ITexture;
import lumien.custommainmenu.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class GuiCustom
extends GuiScreen
implements GuiYesNoCallback {
    public static Config config;
    int buttonCounter;
    int panoramaTimer;
    ArrayList<GuiCustomLabel> textLabels;
    private ITexture[] titlePanoramaPaths;
    public Object beingChecked;
    public GuiConfig guiConfig;
    Random rand;
    protected DynamicTexture viewportTexture;
    protected ResourceLocation field_110351_G;
    protected String splashText;
    protected int field_92024_r;
    protected int field_92023_s;
    protected int field_92022_t;
    protected int field_92021_u;
    protected int field_92020_v;
    protected int field_92019_w;
    private boolean loadedSplashText;

    public GuiCustom(GuiConfig guiConfig) {
        this.guiConfig = guiConfig;
        this.rand = new Random();
        this.loadedSplashText = false;
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    private void loadSplashTexts() {
        if (this.guiConfig.splashText != null) {
            String texts = this.guiConfig.splashText.texts.get();
            String[] seperateLines = texts.split("\n");
            this.splashText = seperateLines[this.rand.nextInt(seperateLines.length)];
        }
    }

    public void func_73866_w_() {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        if (!this.loadedSplashText && this.guiConfig.splashText != null) {
            if (this.guiConfig.splashText.synced) {
                this.splashText = CustomMainMenu.INSTANCE.config.getGUI((String)"mainmenu").splashText;
            } else {
                this.loadSplashTexts();
            }
            this.loadedSplashText = true;
        }
        this.textLabels = new ArrayList();
        this.buttonCounter = 0;
        this.viewportTexture = new DynamicTexture(256, 256);
        this.field_110351_G = this.field_146297_k.func_110434_K().func_110578_a("background", this.viewportTexture);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(2) + 1 == 11 && calendar.get(5) == 9) {
            this.splashText = "Happy birthday, ez!";
        } else if (calendar.get(2) + 1 == 6 && calendar.get(5) == 1) {
            this.splashText = "Happy birthday, Notch!";
        } else if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
            this.splashText = "Merry X-mas!";
        } else if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
            this.splashText = "Happy new year!";
        } else if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31) {
            this.splashText = "OOoooOOOoooo! Spooky!";
        }
        int idCounter = 6000;
        for (Button b : this.guiConfig.customButtons) {
            if (b.wrappedButtonID != -1) {
                this.field_146292_n.add(this.alignButton(b, new GuiCustomWrappedButton(b.wrappedButtonID, b.wrappedButtonID, b)));
                continue;
            }
            this.field_146292_n.add(this.alignButton(b, new GuiCustomButton(idCounter, b)));
            ++idCounter;
        }
        for (Label t : this.guiConfig.customLabels) {
            this.textLabels.add(new GuiCustomLabel(this, t, this.modX(t.posX, t.alignment), this.modY(t.posY, t.alignment)));
        }
    }

    private GuiCustomButton alignButton(Button configButton, GuiCustomButton guiButton) {
        if (configButton != null) {
            guiButton.field_146128_h = this.modX(configButton.posX, configButton.alignment);
            guiButton.field_146129_i = this.modY(configButton.posY, configButton.alignment);
        }
        return guiButton;
    }

    public void func_73878_a(boolean result, int id) {
        if (result) {
            String link = null;
            if (this.beingChecked instanceof Button) {
                Button button = (Button)this.beingChecked;
                if (button.action != null && button.action instanceof ActionOpenLink) {
                    link = ((ActionOpenLink)button.action).getLink();
                }
            } else if (this.beingChecked instanceof Label) {
                Label text = (Label)this.beingChecked;
                if (text.action != null && text.action instanceof ActionOpenLink) {
                    link = ((ActionOpenLink)text.action).getLink();
                }
            }
            if (link != null) {
                try {
                    Class<?> oclass = Class.forName("java.awt.Desktop");
                    Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
                    oclass.getMethod("browse", URI.class).invoke(object, new URI(link));
                }
                catch (Throwable throwable) {
                    CustomMainMenu.INSTANCE.logger.error("Couldn't open link", throwable);
                }
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (GuiCustomLabel label : this.textLabels) {
                label.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int w;
        Panorama panorama = this.guiConfig.panorama;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        if (panorama != null) {
            this.titlePanoramaPaths = panorama.locations;
            GlStateManager.func_179118_c();
            this.renderSkybox(mouseX, mouseY, partialTicks);
            GlStateManager.func_179141_d();
            if (panorama.gradient) {
                this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -2130706433, 0xFFFFFF);
                this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0, Integer.MIN_VALUE);
            }
        } else {
            GL11.glBegin((int)7);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)this.field_146295_m, (float)0.0f);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)this.field_146294_l, (float)this.field_146295_m, (float)0.0f);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)this.field_146294_l, (float)0.0f, (float)0.0f);
            GL11.glEnd();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Background background = this.guiConfig.background;
        if (background != null) {
            if (!background.ichBinEineSlideshow) {
                GlStateManager.func_179147_l();
                background.image.bind();
                this.drawBackground(background.mode);
                GlStateManager.func_179084_k();
            } else {
                background.slideShow.getCurrentResource1().bind();
                this.drawBackground(background.mode);
                if (background.slideShow.fading()) {
                    GlStateManager.func_179147_l();
                    background.slideShow.getCurrentResource2().bind();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)background.slideShow.getAlphaFade(partialTicks));
                    this.drawBackground(background.mode);
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (Image i : this.guiConfig.customImages) {
            int posX = this.modX(i.posX, i.alignment);
            int posY = this.modY(i.posY, i.alignment);
            if (i.ichBinEineSlideshow) {
                i.slideShow.getCurrentResource1().bind();
                RenderUtil.drawCompleteImage(posX, posY, i.width, i.height);
                if (!i.slideShow.fading()) continue;
                GlStateManager.func_179147_l();
                i.slideShow.getCurrentResource2().bind();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)i.slideShow.getAlphaFade(partialTicks));
                RenderUtil.drawCompleteImage(posX, posY, i.width, i.height);
                GlStateManager.func_179084_k();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                continue;
            }
            if (i.hoverImage != null && mouseX >= posX && mouseX <= posX + i.width && mouseY >= posY && mouseY <= posY + i.height) {
                i.hoverImage.bind();
            } else {
                i.image.bind();
            }
            RenderUtil.drawCompleteImage(posX, posY, i.width, i.height);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SplashText splashText = this.guiConfig.splashText;
        if (splashText != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.modX(splashText.posX, splashText.alignment), (float)this.modY(splashText.posY, splashText.alignment), (float)0.0f);
            GlStateManager.func_179114_b((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f1 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71386_F() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
            f1 = f1 * 100.0f / (float)(this.field_146289_q.func_78256_a(this.splashText) + 32);
            GlStateManager.func_179152_a((float)f1, (float)f1, (float)f1);
            this.func_73732_a(this.field_146289_q, this.splashText, 0, -8, splashText.color);
            GlStateManager.func_179121_F();
        }
        for (GuiCustomLabel label : this.textLabels) {
            label.drawLabel(this.field_146297_k, mouseX, mouseY);
        }
        for (w = 0; w < this.field_146292_n.size(); ++w) {
            ((GuiButton)this.field_146292_n.get(w)).func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        for (Object o : this.field_146292_n) {
            if (!(o instanceof GuiCustomButton)) continue;
            ((GuiCustomButton)((Object)o)).drawTooltip(this.field_146297_k, mouseX, mouseY);
        }
        for (w = 0; w < this.field_146293_o.size(); ++w) {
            ((GuiLabel)this.field_146293_o.get(w)).func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    private void drawImageWithMode(MODE mode, int x, int y, int width, int height) {
        int imageWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int imageHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int drawWidth = 0;
        int drawHeight = 0;
        float factorWidth = (float)width / (float)imageWidth;
        float factorHeight = (float)height / (float)imageHeight;
        switch (mode) {
            case FILL: {
                if (factorWidth > factorHeight) {
                    drawWidth = (int)((float)imageWidth * factorWidth);
                    drawHeight = (int)((float)imageHeight * factorWidth);
                } else {
                    drawWidth = (int)((float)imageWidth * factorHeight);
                    drawHeight = (int)((float)imageHeight * factorHeight);
                }
                RenderUtil.drawPartialImage(x, y, 0, 0, drawWidth, drawHeight, imageWidth, imageHeight);
                break;
            }
            case STRETCH: {
                RenderUtil.drawCompleteImage(x, y, width, height);
                break;
            }
            case CENTER: {
                RenderUtil.drawCompleteImage(x + (int)((float)width / 2.0f - (float)imageWidth / 2.0f), y + (int)((float)height / 2.0f - (float)imageHeight / 2.0f), imageWidth, imageHeight);
                break;
            }
            case TILE: {
                int countX = (int)Math.ceil((float)width / (float)imageWidth);
                int countY = (int)Math.ceil((float)height / (float)imageHeight);
                for (int cX = 0; cX < countX; ++cX) {
                    for (int cY = 0; cY < countY; ++cY) {
                        RenderUtil.drawCompleteImage(x + cX * imageWidth, y + cY * imageHeight, imageWidth, imageHeight);
                    }
                }
                break;
            }
        }
    }

    private void drawBackground(MODE mode) {
        this.drawImageWithMode(mode, 0, 0, this.field_146294_l, this.field_146295_m);
    }

    protected void renderSkybox(int p_73971_1_, int p_73971_2_, float p_73971_3_) {
        this.field_146297_k.func_147110_a().func_147609_e();
        GlStateManager.func_179083_b((int)0, (int)0, (int)256, (int)256);
        this.drawPanorama(p_73971_1_, p_73971_2_, p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.field_146297_k.func_147110_a().func_147610_a(true);
        GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
        float f = this.field_146294_l > this.field_146295_m ? 120.0f / (float)this.field_146294_l : 120.0f / (float)this.field_146295_m;
        float f1 = (float)this.field_146295_m * f / 256.0f;
        float f2 = (float)this.field_146294_l * f / 256.0f;
        int i = this.field_146294_l;
        int j = this.field_146295_m;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b(0.0, (double)j, (double)this.field_73735_i).func_187315_a((double)(0.5f - f1), (double)(0.5f + f2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_181662_b((double)i, (double)j, (double)this.field_73735_i).func_187315_a((double)(0.5f - f1), (double)(0.5f - f2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_181662_b((double)i, 0.0, (double)this.field_73735_i).func_187315_a((double)(0.5f + f1), (double)(0.5f - f2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 0.0, (double)this.field_73735_i).func_187315_a((double)(0.5f + f1), (double)(0.5f + f2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawPanorama(int p_73970_1_, int p_73970_2_, float p_73970_3_) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int i = 8;
        for (int j = 0; j < i * i; ++j) {
            GlStateManager.func_179094_E();
            float f = ((float)(j % i) / (float)i - 0.5f) / 64.0f;
            float f1 = ((float)(j / i) / (float)i - 0.5f) / 64.0f;
            float f2 = 0.0f;
            GlStateManager.func_179109_b((float)f, (float)f1, (float)f2);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(((float)this.panoramaTimer + p_73970_3_) / 400.0f)) * 25.0f + 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-((float)this.panoramaTimer + p_73970_3_) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int k = 0; k < 6; ++k) {
                GlStateManager.func_179094_E();
                if (k == 1) {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 2) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 3) {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (k == 4) {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (k == 5) {
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                this.titlePanoramaPaths[k].bind();
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                int l = 255 / (j + 1);
                float f3 = 0.0f;
                vertexBuffer.func_181662_b(-1.0, -1.0, 1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                vertexBuffer.func_181662_b(1.0, -1.0, 1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                vertexBuffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                vertexBuffer.func_181662_b(-1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
    }

    public void func_73876_c() {
        for (Image i : this.guiConfig.customImages) {
            if (!i.ichBinEineSlideshow) continue;
            i.slideShow.update();
        }
        if (this.guiConfig.panorama != null) {
            if (this.guiConfig.panorama.synced) {
                GuiCustom mainMenu = CustomMainMenu.INSTANCE.config.getGUI("mainmenu");
                this.panoramaTimer = mainMenu.panoramaTimer;
                this.panoramaTimer = mainMenu.guiConfig.panorama.animate ? (this.panoramaTimer += mainMenu.guiConfig.panorama.animationSpeed) : mainMenu.guiConfig.panorama.position;
                mainMenu.panoramaTimer = this.panoramaTimer;
            } else {
                this.panoramaTimer = this.guiConfig.panorama.animate ? (this.panoramaTimer += this.guiConfig.panorama.animationSpeed) : this.guiConfig.panorama.position;
            }
        }
        if (this.guiConfig.background != null && this.guiConfig.background.ichBinEineSlideshow) {
            this.guiConfig.background.slideShow.update();
        }
        if (Keyboard.isKeyDown((int)29) && Keyboard.isKeyDown((int)19)) {
            CustomMainMenu.INSTANCE.reload();
            if (Keyboard.isKeyDown((int)42)) {
                this.field_146297_k.func_110436_a();
            }
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMainMenu());
        }
    }

    private void rotateAndBlurSkybox(float p_73968_1_) {
        this.field_146297_k.func_110434_K().func_110577_a(this.field_110351_G);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        GlStateManager.func_179118_c();
        int i = 3;
        if (this.guiConfig.panorama.blur) {
            for (int j = 0; j < i; ++j) {
                float f = 1.0f / (float)(j + 1);
                int k = this.field_146294_l;
                int l = this.field_146295_m;
                float f1 = (float)(j - i / 2) / 256.0f;
                vertexBuffer.func_181662_b((double)k, (double)l, (double)this.field_73735_i).func_187315_a((double)(0.0f + f1), 1.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
                vertexBuffer.func_181662_b((double)k, 0.0, (double)this.field_73735_i).func_187315_a((double)(1.0f + f1), 1.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
                vertexBuffer.func_181662_b(0.0, 0.0, (double)this.field_73735_i).func_187315_a((double)(1.0f + f1), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
                vertexBuffer.func_181662_b(0.0, (double)l, (double)this.field_73735_i).func_187315_a((double)(0.0f + f1), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private int modX(int posX, Alignment alignment) {
        return (int)((float)posX + (float)this.field_146294_l * alignment.factorX);
    }

    private int modY(int posY, Alignment alignment) {
        return (int)((float)posY + (float)this.field_146295_m * alignment.factorY);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiCustomWrappedButton && this.guiConfig.name.equals("mainmenu")) {
            GuiCustomWrappedButton wrapped = (GuiCustomWrappedButton)button;
            if (wrapped.wrappedButton != null) {
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)new GuiFakeMain(), wrapped.wrappedButton, new ArrayList());
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                event.getButton().func_146113_a(this.field_146297_k.func_147118_V());
                if (((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) {
                    MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)new GuiFakeMain(), wrapped.wrappedButton, new ArrayList()));
                }
            }
        } else if (button.field_146127_k >= 6000 && button instanceof GuiCustomButton) {
            GuiCustomButton custom = (GuiCustomButton)button;
            if (custom.b.action != null) {
                custom.b.action.perform(custom.b, this);
            }
        }
    }
}

