/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.google.common.base.Predicate;
import com.minemaarten.signals.block.BlockSignalBase;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.lib.Log;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketUpdateMessage;
import com.minemaarten.signals.rail.DestinationPathFinder;
import com.minemaarten.signals.rail.NetworkController;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class TileEntitySignalBase
extends TileEntityBase
implements ITickable {
    private boolean firstTick = true;
    private List<EntityMinecart> routedMinecarts = new ArrayList<EntityMinecart>();
    private Set<TileEntitySignalBase> nextSignals = new HashSet<TileEntitySignalBase>();
    private String text = "";
    private String arguments = "";
    private EnumForceMode forceMode = EnumForceMode.NONE;

    public BlockPos getNeighborPos() {
        return this.func_174877_v().func_177972_a(this.getFacing().func_176735_f());
    }

    public RailWrapper getConnectedRail() {
        BlockPos neighborPos = this.getNeighborPos();
        RailWrapper rail = RailCacheManager.getInstance(this.func_145831_w()).getRail(this.func_145831_w(), neighborPos);
        return rail != null && rail.isStraightTrack() && rail.getNeighbors().size() <= 2 ? rail : null;
    }

    public List<RailWrapper> getConnectedRails() {
        RailWrapper neighbor = this.getConnectedRail();
        return neighbor != null ? TileEntitySignalBase.getConnectedRails(neighbor, this.getFacing().func_176734_d()) : new ArrayList<RailWrapper>();
    }

    public static List<RailWrapper> getConnectedRails(RailWrapper neighbor, EnumFacing traverseDirection) {
        ArrayList<RailWrapper> neighbors = new ArrayList<RailWrapper>();
        Block railType = neighbor.state.func_177230_c();
        block0: for (int i = 0; i < 5 && neighbor != null; ++i) {
            neighbors.add(neighbor);
            Map<RailWrapper, EnumFacing> railNeighbors = neighbor.getNeighbors();
            neighbor = null;
            for (Map.Entry<RailWrapper, EnumFacing> entry : railNeighbors.entrySet()) {
                if (entry.getValue() != traverseDirection || railType != entry.getKey().state.func_177230_c()) continue;
                neighbor = entry.getKey();
                continue block0;
            }
        }
        return neighbors;
    }

    private IBlockState getBlockState() {
        return this.func_145831_w() != null ? this.func_145831_w().func_180495_p(this.func_174877_v()) : null;
    }

    protected EnumFacing getFacing() {
        IBlockState state = this.getBlockState();
        return state != null && state.func_177230_c() instanceof BlockSignalBase ? (EnumFacing)state.func_177229_b(BlockSignalBase.FACING) : EnumFacing.NORTH;
    }

    protected void setLampStatus(BlockSignalBase.EnumLampStatus lampStatus) {
        if (this.forceMode == EnumForceMode.FORCED_GREEN_ONCE) {
            lampStatus = BlockSignalBase.EnumLampStatus.GREEN;
        } else if (this.forceMode == EnumForceMode.FORCED_RED) {
            lampStatus = BlockSignalBase.EnumLampStatus.RED;
        }
        IBlockState state = this.getBlockState();
        if (state.func_177227_a().contains(BlockSignalBase.LAMP_STATUS) && state.func_177229_b(BlockSignalBase.LAMP_STATUS) != lampStatus) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a(BlockSignalBase.LAMP_STATUS, (Comparable)((Object)lampStatus)));
            NetworkController.getInstance(this.func_145831_w()).updateColor(this, this.func_174877_v());
            if (lampStatus == BlockSignalBase.EnumLampStatus.GREEN) {
                for (EntityMinecart cart : this.getNeighborMinecarts()) {
                    if (!(new Vec3d(cart.field_70159_w, cart.field_70181_x, cart.field_70179_y).func_72433_c() < 0.01) && EnumFacing.func_176737_a((float)((float)cart.field_70159_w), (float)0.0f, (float)((float)cart.field_70179_y)) != this.getFacing()) continue;
                    cart.field_70159_w += (double)this.getFacing().func_82601_c() * 0.1;
                    cart.field_70179_y += (double)this.getFacing().func_82599_e() * 0.1;
                    long start = System.nanoTime();
                    DestinationPathFinder.AStarRailNode path = this.routeCart(cart, this.getFacing(), true);
                    if (path != null) {
                        this.updateSwitches(path, cart, true);
                    }
                    Log.debug((System.nanoTime() - start) / 1000L + "ns");
                }
            }
        }
    }

    public BlockSignalBase.EnumLampStatus getLampStatus() {
        IBlockState state;
        if (this.func_145831_w() != null && (state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177227_a().contains(BlockSignalBase.LAMP_STATUS)) {
            return (BlockSignalBase.EnumLampStatus)((Object)state.func_177229_b(BlockSignalBase.LAMP_STATUS));
        }
        return BlockSignalBase.EnumLampStatus.YELLOW_BLINKING;
    }

    protected List<EntityMinecart> getNeighborMinecarts() {
        return TileEntitySignalBase.getMinecarts(this.field_145850_b, this.getConnectedRails());
    }

    protected DestinationPathFinder.AStarRailNode routeCart(EntityMinecart cart, EnumFacing cartDir, boolean submitMessages) {
        CapabilityMinecartDestination capability = (CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
        String destination = capability.getCurrentDestination();
        Pattern destinationRegex = capability.getCurrentDestinationRegex();
        ArrayList<PacketUpdateMessage> messages = new ArrayList<PacketUpdateMessage>();
        DestinationPathFinder.AStarRailNode path = null;
        if (!destination.isEmpty()) {
            messages.add(new PacketUpdateMessage(this, cart, "signals.message.routing_cart", destination));
            EnumFacing facing = this.getFacing();
            if (facing == cartDir) {
                path = DestinationPathFinder.pathfindToDestination(this.getConnectedRail(), cart, destinationRegex, facing);
                if (path == null) {
                    messages.add(new PacketUpdateMessage(this, cart, "signals.message.no_path_found", new String[0]));
                } else {
                    messages.add(new PacketUpdateMessage(this, cart, "signals.message.path_found", new String[0]));
                }
            }
        } else {
            messages.add(new PacketUpdateMessage(this, cart, "signals.message.no_destination", new String[0]));
        }
        if (submitMessages) {
            for (PacketUpdateMessage message : messages) {
                NetworkHandler.sendToAllAround(message, this.func_145831_w());
            }
        }
        capability.setPath(cart, path);
        return path;
    }

    protected void updateSwitches(DestinationPathFinder.AStarRailNode pathNode, EntityMinecart cart, boolean submitMessages) {
        ArrayList<PacketUpdateMessage> messages = new ArrayList<PacketUpdateMessage>();
        EnumFacing lastHeading = null;
        while (pathNode != null) {
            EnumFacing heading;
            Map<RailWrapper, EnumFacing> neighbors = pathNode.getRail().getNeighbors();
            EnumFacing enumFacing = heading = pathNode.getNextNode() != null ? neighbors.get((Object)pathNode.getNextNode().getRail()) : null;
            if (neighbors.size() > 2 && heading != null && lastHeading != null) {
                BlockRailBase.EnumRailDirection railDir = RailWrapper.getRailDir(EnumSet.of(heading, lastHeading.func_176734_d()));
                String[] args = new String[]{Integer.toString(pathNode.getRail().func_177958_n()), Integer.toString(pathNode.getRail().func_177956_o()), Integer.toString(pathNode.getRail().func_177952_p()), "signals.dir." + lastHeading.toString().toLowerCase(), "signals.dir." + heading.toString().toLowerCase()};
                if (pathNode.getRail().setRailDir(railDir)) {
                    messages.add(new PacketUpdateMessage(this, cart, "signals.message.changing_junction", args));
                } else {
                    messages.add(new PacketUpdateMessage(this, cart, "signals.message.changing_junction", args));
                }
            }
            lastHeading = heading;
            pathNode = pathNode.getNextNode();
        }
        if (submitMessages) {
            for (PacketUpdateMessage message : messages) {
                NetworkHandler.sendToAllAround(message, this.func_145831_w());
            }
        }
    }

    protected static Set<RailWrapper> getRailsToNextBlockSection(RailWrapper curRail, EnumFacing direction) {
        HashSet<RailWrapper> rails = new HashSet<RailWrapper>();
        LinkedList<Map.Entry<RailWrapper, EnumFacing>> traversingRails = new LinkedList<Map.Entry<RailWrapper, EnumFacing>>();
        for (Map.Entry<RailWrapper, EnumFacing> entry : curRail.getNeighbors().entrySet()) {
            if (entry.getValue() == direction.func_176734_d()) continue;
            traversingRails.add(entry);
        }
        rails.add(curRail);
        while (!traversingRails.isEmpty()) {
            Map.Entry neighbor = (Map.Entry)traversingRails.poll();
            TileEntitySignalBase neighborSignal = TileEntitySignalBase.getNeighborSignal((RailWrapper)((Object)neighbor.getKey()), (EnumFacing)neighbor.getValue());
            if (neighborSignal == null) {
                rails.add((RailWrapper)((Object)neighbor.getKey()));
                if (!((RailWrapper)((Object)neighbor.getKey())).getSignals().isEmpty()) continue;
                for (Map.Entry<RailWrapper, EnumFacing> entry : ((RailWrapper)((Object)neighbor.getKey())).getNeighbors().entrySet()) {
                    BlockPos nextNeighbor = entry.getKey();
                    if (rails.contains(nextNeighbor)) continue;
                    traversingRails.add(entry);
                }
                continue;
            }
            if (curRail.world.func_82737_E() % 20L == 0L) {
                // empty if block
            }
            if (neighborSignal.getLampStatus() == BlockSignalBase.EnumLampStatus.RED) continue;
            rails.addAll(TileEntitySignalBase.getConnectedRails((RailWrapper)((Object)neighbor.getKey()), neighborSignal.getFacing().func_176734_d()));
        }
        rails.remove((Object)curRail);
        return rails;
    }

    protected static <T extends TileEntitySignalBase> T getNeighborSignal(World world, BlockPos pos, Class<T> teClass, EnumFacing blacklistedSignalDir) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntitySignalBase signal;
            BlockPos neighbor = pos.func_177972_a(dir);
            TileEntity te = world.func_175625_s(neighbor);
            if (te == null || !teClass.isAssignableFrom(te.getClass()) || (signal = (TileEntitySignalBase)te).getFacing().func_176746_e() != dir || signal.getFacing() == blacklistedSignalDir) continue;
            return (T)((Object)signal);
        }
        return null;
    }

    public static TileEntitySignalBase getNeighborSignal(RailWrapper rail, EnumFacing blacklistedSignalDir) {
        for (Map.Entry<EnumFacing, TileEntitySignalBase> entry : rail.getSignals().entrySet()) {
            if (entry.getValue().getFacing().func_176746_e() != entry.getKey() || entry.getValue().getFacing() == blacklistedSignalDir) continue;
            return entry.getValue();
        }
        return null;
    }

    public static List<EntityMinecart> getMinecarts(World worldObj, final Collection<RailWrapper> railsOnBlock) {
        if (railsOnBlock.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<World> worlds = new HashSet<World>();
        for (RailWrapper pos : railsOnBlock) {
            worlds.add(pos.world);
        }
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (World world : worlds) {
            BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
            for (RailWrapper pos : railsOnBlock) {
                min.func_181079_c(Math.min(min.func_177958_n(), pos.func_177958_n()), Math.min(min.func_177956_o(), pos.func_177956_o()), Math.min(min.func_177952_p(), pos.func_177952_p()));
                max.func_181079_c(Math.max(max.func_177958_n(), pos.func_177958_n()), Math.max(max.func_177956_o(), pos.func_177956_o()), Math.max(max.func_177952_p(), pos.func_177952_p()));
            }
            carts.addAll(world.func_175647_a(EntityMinecart.class, new AxisAlignedBB((BlockPos)min, max.func_177982_a(1, 2, 1)), (Predicate)new Predicate<EntityMinecart>(){

                public boolean apply(EntityMinecart cart) {
                    BlockPos cartPos = cart.func_180425_c();
                    return railsOnBlock.contains(cartPos) || railsOnBlock.contains(cartPos.func_177977_b());
                }
            }));
        }
        return carts;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            RailWrapper neighbor = this.getConnectedRail();
            if (neighbor != null) {
                neighbor.updateSignalCache();
            }
            NetworkController.getInstance(this.func_145831_w()).updateColor((TileEntitySignalBase)null, this.func_174877_v());
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.firstTick) {
                this.firstTick = false;
                RailWrapper neighbor = this.getConnectedRail();
                if (neighbor != null) {
                    neighbor.updateSignalCache();
                }
                NetworkController.getInstance(this.func_145831_w()).updateColor(this, this.func_174877_v());
            }
            List<EntityMinecart> carts = this.getNeighborMinecarts();
            for (EntityMinecart cart : carts) {
                if (this.routedMinecarts.contains(cart)) continue;
                cart.field_71088_bW = 0;
                this.onCartEnteringBlock(cart);
            }
            for (EntityMinecart cart : this.routedMinecarts) {
                if (carts.contains(cart)) continue;
                this.onCartLeavingBlock(cart);
            }
            this.routedMinecarts = carts;
            RailWrapper neighbor = this.getConnectedRail();
            if (neighbor != null) {
                this.updateConnectedSignals(neighbor);
            }
        }
    }

    protected abstract void onCartEnteringBlock(EntityMinecart var1);

    protected void onCartLeavingBlock(EntityMinecart cart) {
        if (this.forceMode == EnumForceMode.FORCED_GREEN_ONCE) {
            this.setForceMode(EnumForceMode.NONE);
        }
    }

    public void updateConnectedSignals(RailWrapper curRail) {
        EnumFacing direction = this.getFacing();
        HashSet<RailWrapper> rails = new HashSet<RailWrapper>();
        LinkedList<Map.Entry<RailWrapper, EnumFacing>> traversingRails = new LinkedList<Map.Entry<RailWrapper, EnumFacing>>();
        HashSet<TileEntitySignalBase> signals = new HashSet<TileEntitySignalBase>();
        for (Map.Entry<RailWrapper, EnumFacing> entry : curRail.getNeighbors().entrySet()) {
            if (entry.getValue() == direction.func_176734_d()) continue;
            traversingRails.add(entry);
        }
        rails.add(curRail);
        while (!traversingRails.isEmpty()) {
            Map.Entry neighbor = (Map.Entry)traversingRails.poll();
            TileEntitySignalBase neighborSignal = TileEntitySignalBase.getNeighborSignal((RailWrapper)((Object)neighbor.getKey()), (EnumFacing)neighbor.getValue());
            if (neighborSignal != null) continue;
            rails.add((RailWrapper)((Object)neighbor.getKey()));
            if (((RailWrapper)((Object)neighbor.getKey())).getSignals().isEmpty()) {
                for (Map.Entry<RailWrapper, EnumFacing> entry : ((RailWrapper)((Object)neighbor.getKey())).getNeighbors().entrySet()) {
                    BlockPos nextNeighbor = entry.getKey();
                    if (rails.contains(nextNeighbor)) continue;
                    traversingRails.add(entry);
                }
                continue;
            }
            signals.add(((RailWrapper)((Object)neighbor.getKey())).getSignals().values().iterator().next());
        }
        if (!signals.equals(this.nextSignals)) {
            this.nextSignals = signals;
            this.sendUpdatePacket();
        }
    }

    public Set<TileEntitySignalBase> getNextSignals() {
        return this.nextSignals;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (TileEntitySignalBase signal : this.nextSignals) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74768_a("x", signal.func_174877_v().func_177958_n());
            t.func_74768_a("y", signal.func_174877_v().func_177956_o());
            t.func_74768_a("z", signal.func_174877_v().func_177952_p());
            list.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("signals", (NBTBase)list);
        tag.func_74778_a("text", this.text);
        tag.func_74778_a("arguments", this.arguments);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == 0) {
            this.nextSignals.clear();
            NBTTagList list = pkt.func_148857_g().func_150295_c("signals", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound t = list.func_150305_b(i);
                BlockPos pos = new BlockPos(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z"));
                TileEntity te = this.field_145850_b.func_175625_s(pos);
                if (!(te instanceof TileEntitySignalBase)) continue;
                this.nextSignals.add((TileEntitySignalBase)te);
            }
            this.text = pkt.func_148857_g().func_74779_i("text");
            this.arguments = pkt.func_148857_g().func_74779_i("arguments");
        }
    }

    protected void setMessage(String message, Object ... arguments) {
        this.text = message;
        this.arguments = "";
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                this.arguments = this.arguments + "\n";
            }
            this.arguments = this.arguments + arguments[i].toString();
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.getBlockState(), this.getBlockState(), 3);
    }

    public String getMessage() {
        String[] localizedArguments = this.arguments.split("\n");
        for (int i = 0; i < localizedArguments.length; ++i) {
            localizedArguments[i] = I18n.func_135052_a((String)localizedArguments[i], (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)this.text, (Object[])localizedArguments);
    }

    public void setForceMode(EnumForceMode forceMode) {
        this.forceMode = forceMode;
        this.func_70296_d();
        if (forceMode == EnumForceMode.FORCED_GREEN_ONCE) {
            this.setLampStatus(BlockSignalBase.EnumLampStatus.GREEN);
            this.setMessage("signals.signal_message.forced_green", new Object[0]);
        } else if (forceMode == EnumForceMode.FORCED_RED) {
            this.setLampStatus(BlockSignalBase.EnumLampStatus.RED);
            this.setMessage("signals.signal_message.forced_red", new Object[0]);
        } else {
            this.setMessage("", new Object[0]);
        }
    }

    public EnumForceMode getForceMode() {
        return this.forceMode;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("forceMode", (byte)this.forceMode.ordinal());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.forceMode = EnumForceMode.values()[tag.func_74771_c("forceMode")];
    }

    public static enum EnumForceMode {
        NONE,
        FORCED_GREEN_ONCE,
        FORCED_RED;

    }
}

