/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.minemaarten.signals.block.BlockRailLink;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.TileEntityBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TileEntityRailLink
extends TileEntityBase
implements ITickable {
    private BlockPos linkedPos;
    private int linkedDimension;
    private RailWrapper linkedRail;

    public RailWrapper getLinkedRail() {
        WorldServer linkedWorld;
        if (this.linkedRail == null && this.linkedPos != null && (linkedWorld = DimensionManager.getWorld((int)this.linkedDimension)) != null && linkedWorld.func_175668_a(this.linkedPos, false)) {
            RailWrapper rail = RailCacheManager.getInstance(this.linkedDimension).getRail((World)linkedWorld, this.linkedPos);
            if (rail != null) {
                this.setLinkedRail(rail);
            }
            return rail;
        }
        return this.linkedRail;
    }

    public void onLinkedRailInvalidated() {
        this.linkedRail = null;
        this.updateLinkState();
    }

    public void setLinkedRail(RailWrapper rail) {
        if (rail != this.linkedRail) {
            if (this.linkedRail != null) {
                this.linkedRail.unlink(this);
            }
            if (rail != null) {
                rail.link(this);
                this.linkedRail = rail;
                this.linkedPos = rail;
                this.linkedDimension = rail.world.field_73011_w.getDimension();
            } else {
                this.linkedPos = null;
                this.linkedDimension = 0;
            }
            this.updateLinkState();
        }
    }

    private void updateLinkState() {
        this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockRailLink.CONNECTED, (Comparable)Boolean.valueOf(this.linkedRail != null)), 2);
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.linkedPos != null) {
            tag.func_74768_a("linkedX", this.linkedPos.func_177958_n());
            tag.func_74768_a("linkedY", this.linkedPos.func_177956_o());
            tag.func_74768_a("linkedZ", this.linkedPos.func_177952_p());
        }
        tag.func_74768_a("linkedDim", this.linkedDimension);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.linkedPos = tag.func_74764_b("linkedX") ? new BlockPos(tag.func_74762_e("linkedX"), tag.func_74762_e("linkedY"), tag.func_74762_e("linkedZ")) : null;
        this.linkedDimension = tag.func_74762_e("linkedDim");
        super.func_145839_a(tag);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 100L == 0L) {
            this.getLinkedRail();
        }
    }
}

