/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.minemaarten.signals.block.BlockSignalBase;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.lib.Log;
import com.minemaarten.signals.rail.DestinationPathFinder;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityPathSignal
extends TileEntitySignalBase
implements ITickable {
    private int pathingTimer;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.pathingTimer-- <= 0 && this.getForceMode() == TileEntitySignalBase.EnumForceMode.NONE) {
            this.route();
        }
    }

    public void route() {
        this.pathingTimer = 20;
        RailWrapper neighborRail = this.getConnectedRail();
        if (neighborRail != null) {
            List<EntityMinecart> routingMinecarts = this.getNeighborMinecarts();
            if (!routingMinecarts.isEmpty()) {
                Set<RailWrapper> rails = TileEntityPathSignal.getRailsToNextBlockSection(neighborRail, this.getFacing());
                List<EntityMinecart> cartsOnNextBlock = TileEntityPathSignal.getMinecarts(this.field_145850_b, rails);
                for (EntityMinecart routingCart : routingMinecarts) {
                    if (this.routeCart(routingCart, this.getFacing(), false) != null) continue;
                    this.setLampStatus(cartsOnNextBlock.isEmpty() ? BlockSignalBase.EnumLampStatus.GREEN : BlockSignalBase.EnumLampStatus.RED);
                    this.setMessage("signals.signal_message.cart_without_destination", new Object[0]);
                    Log.debug("[Path Signal] Cart routed without destination. Block signal behaviour.");
                    return;
                }
                for (EntityMinecart cartOnNextBlock : cartsOnNextBlock) {
                    if (this.getStoredPath(cartOnNextBlock) != null) continue;
                    this.setLampStatus(BlockSignalBase.EnumLampStatus.RED);
                    BlockPos pos = cartOnNextBlock.func_180425_c();
                    this.setMessage("signals.signal_message.cart_on_track_without_destination", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    Log.debug("[Path Signal] Cart on rails without destination. Red signal. Cart: " + cartOnNextBlock.func_180425_c());
                    return;
                }
                HashSet<BlockPos> claimingPositions = new HashSet<BlockPos>();
                for (EntityMinecart routingCart : routingMinecarts) {
                    claimingPositions.addAll(this.getToBeTraversedCoordinates(routingCart));
                }
                for (EntityMinecart cartOnNextBlock : cartsOnNextBlock) {
                    List<BlockPos> list = this.getToBeTraversedCoordinates(cartOnNextBlock);
                    for (BlockPos pos : list) {
                        if (!claimingPositions.contains(pos)) continue;
                        this.setLampStatus(BlockSignalBase.EnumLampStatus.RED);
                        BlockPos p = cartOnNextBlock.func_180425_c();
                        this.setMessage("signals.signal_message.cart_intersecting_path", p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                        Log.debug("[Path Signal] Cart on rails intersecting the path of the routed cart. Red signal. Cart: " + cartOnNextBlock.func_180425_c());
                        return;
                    }
                }
                this.setLampStatus(BlockSignalBase.EnumLampStatus.GREEN);
            } else {
                this.setMessage("signals.signal_message.standby", new Object[0]);
                this.setLampStatus(BlockSignalBase.EnumLampStatus.YELLOW);
            }
        } else {
            this.setLampStatus(BlockSignalBase.EnumLampStatus.YELLOW_BLINKING);
        }
    }

    @Override
    protected void onCartEnteringBlock(EntityMinecart cart) {
        this.route();
    }

    private DestinationPathFinder.AStarRailNode getStoredPath(EntityMinecart cart) {
        return ((CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null)).getPath(cart.field_70170_p);
    }

    private List<BlockPos> getToBeTraversedCoordinates(EntityMinecart cart) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        BlockPos cartPos = cart.func_180425_c();
        boolean returnOnNext = false;
        for (DestinationPathFinder.AStarRailNode path = this.getStoredPath(cart); path != null; path = path.getNextNode()) {
            coords.add(path.getRail());
            if (returnOnNext) {
                return coords;
            }
            if (!path.getRail().equals(cartPos)) continue;
            returnOnNext = true;
        }
        return coords;
    }
}

