/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.minemaarten.signals.api.ICartHopperBehaviour;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.network.GuiSynced;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.tileentity.IGUIButtonSensitive;
import com.minemaarten.signals.tileentity.TileEntityBase;
import com.minemaarten.signals.tileentity.carthopperbehaviour.CartHopperBehaviourItems;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TileEntityCartHopper
extends TileEntityBase
implements ITickable,
IGUIButtonSensitive {
    @GuiSynced
    private HopperMode hopperMode = HopperMode.CART_FULL;
    @GuiSynced
    private boolean interactEngine;
    private EnumFacing pushDir = EnumFacing.NORTH;
    private EntityMinecart managingCart;
    private UUID managingCartId;
    private boolean pushedLastTick;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74774_a("hopperMode", (byte)this.hopperMode.ordinal());
        tag.func_74757_a("interactEngine", this.interactEngine);
        tag.func_74774_a("pushDir", (byte)this.pushDir.ordinal());
        tag.func_74757_a("pushedLastTick", this.pushedLastTick);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.hopperMode = HopperMode.values()[tag.func_74771_c("hopperMode")];
        this.interactEngine = tag.func_74767_n("interactEngine");
        this.pushDir = EnumFacing.values()[tag.func_74771_c("pushDir")];
        this.pushedLastTick = tag.func_74767_n("pushedLastTick");
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            boolean shouldPush;
            if (this.managingCartId != null) {
                List carts = this.func_145831_w().func_175644_a(EntityMinecart.class, (Predicate)new Predicate<EntityMinecart>(){

                    public boolean apply(EntityMinecart input) {
                        return input.getPersistentID().equals(TileEntityCartHopper.this.managingCartId);
                    }
                });
                this.managingCart = carts.isEmpty() ? null : (EntityMinecart)carts.get(0);
                this.managingCartId = null;
            }
            if ((shouldPush = this.tryTransfer(RailCacheManager.getInstance(this.func_145831_w()).getRail(this.func_145831_w(), this.func_174877_v().func_177984_a()) != null)) && !this.pushedLastTick) {
                this.pushCart();
            }
            boolean notifyNeighbors = shouldPush != this.pushedLastTick;
            this.pushedLastTick = shouldPush;
            if (notifyNeighbors) {
                this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
            }
        }
    }

    public boolean emitsRedstone() {
        return this.pushedLastTick;
    }

    public HopperMode getHopperMode() {
        return this.hopperMode;
    }

    public boolean interactsWithEngine() {
        return this.interactEngine;
    }

    private void pushCart() {
        this.managingCart.field_70159_w += (double)this.pushDir.func_82601_c() * 0.1;
        this.managingCart.field_70179_y += (double)this.pushDir.func_82599_e() * 0.1;
    }

    private boolean tryTransfer(boolean extract) {
        this.updateManagingCart(new AxisAlignedBB(extract ? this.func_174877_v().func_177984_a() : this.func_174877_v().func_177977_b()));
        if (this.managingCart != null) {
            boolean active = false;
            boolean empty = false;
            boolean full = false;
            ArrayList filters = Lists.newArrayList();
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                TileEntity filter = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir));
                if (filter == null) continue;
                filters.add(new ImmutablePair((Object)filter, (Object)dir));
            }
            for (ICartHopperBehaviour iCartHopperBehaviour : RailManager.getInstance().getHopperBehaviours()) {
                Object te;
                Capability cap = iCartHopperBehaviour.getCapability();
                if ((!this.interactEngine || !(iCartHopperBehaviour instanceof CartHopperBehaviourItems)) && !this.managingCart.hasCapability(cap, null)) continue;
                Object cart = null;
                if (this.interactEngine && iCartHopperBehaviour instanceof CartHopperBehaviourItems) {
                    CapabilityMinecartDestination destCap;
                    if (this.managingCart.hasCapability(CapabilityMinecartDestination.INSTANCE, null) && (destCap = (CapabilityMinecartDestination)this.managingCart.getCapability(CapabilityMinecartDestination.INSTANCE, null)).isMotorized()) {
                        cart = new InvWrapper((IInventory)destCap.getFuelInv());
                    }
                    if (cart == null) {
                        continue;
                    }
                } else {
                    cart = this.managingCart.getCapability(cap, null);
                }
                if ((te = this.getCapabilityAt(cap, extract ? EnumFacing.DOWN : EnumFacing.UP)) != null && iCartHopperBehaviour.tryTransfer(extract ? cart : te, extract ? te : cart, filters)) {
                    active = true;
                }
                if (this.hopperMode == HopperMode.CART_EMPTY && iCartHopperBehaviour.isCartEmpty(cart, filters)) {
                    empty = true;
                }
                if (this.hopperMode != HopperMode.CART_FULL || !iCartHopperBehaviour.isCartFull(cart)) continue;
                full = true;
            }
            return this.hopperMode == HopperMode.NO_ACTIVITY ? !active : empty || full;
        }
        return false;
    }

    private void updateManagingCart(AxisAlignedBB aabb) {
        List carts;
        if (this.managingCart != null && (this.managingCart.field_70128_L || !this.managingCart.func_174813_aQ().func_72326_a(aabb))) {
            this.managingCart = null;
        }
        if (this.managingCart == null && !(carts = this.func_145831_w().func_72872_a(EntityMinecart.class, aabb)).isEmpty()) {
            this.managingCart = (EntityMinecart)carts.get(0);
            this.pushDir = this.managingCart.func_184172_bi();
        }
    }

    private <T> T getCapabilityAt(Capability<T> cap, EnumFacing dir) {
        BlockPos pos = this.func_174877_v().func_177972_a(dir);
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        return (T)(te != null && te.hasCapability(cap, dir.func_176734_d()) ? te.getCapability(cap, dir.func_176734_d()) : null);
    }

    @Override
    public void handleGUIButtonPress(EntityPlayer player, int ... data) {
        switch (data[0]) {
            case 0: {
                this.hopperMode = HopperMode.values()[(this.hopperMode.ordinal() + 1) % HopperMode.values().length];
                break;
            }
            case 1: {
                this.interactEngine = !this.interactEngine;
            }
        }
    }

    public static enum HopperMode {
        CART_FULL,
        CART_EMPTY,
        NO_ACTIVITY,
        NEVER;

    }
}

