/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail;

import com.minemaarten.signals.block.BlockSignalBase;
import com.minemaarten.signals.lib.Log;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.regex.Pattern;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DestinationPathFinder {
    public static AStarRailNode pathfindToDestination(RailWrapper start, EntityMinecart cart, Pattern destinationRegex, EnumFacing direction) {
        return DestinationPathFinder.pathfindToDestination(start, RailCacheManager.getInstance(start.world).getStationRails(cart, destinationRegex), direction);
    }

    public static AStarRailNode pathfindToDestination(RailWrapper start, Collection<RailWrapper> goals, EnumFacing direction) {
        if (goals.isEmpty()) {
            return null;
        }
        PriorityQueue<AStarRailNode> queue = new PriorityQueue<AStarRailNode>();
        HashSet<RailWrapper> traversedRails = new HashSet<RailWrapper>();
        HashMap<RailWrapper, AStarRailNode> railMap = new HashMap<RailWrapper, AStarRailNode>();
        Map<RailWrapper, AStarRailNode> firstSignals = DestinationPathFinder.getFirstSignals(start, direction, goals);
        Log.debug("Signals: " + firstSignals.size());
        if (firstSignals.isEmpty()) {
            return null;
        }
        int minSignalDistance = DestinationPathFinder.getClosestSignal(firstSignals);
        AStarRailNode bestRoute = null;
        int bestDistance = Integer.MAX_VALUE;
        for (RailWrapper goal : goals) {
            AStarRailNode goalNode = new AStarRailNode(goal, null, start);
            goalNode.distanceFromStart = 0;
            queue.add(goalNode);
            railMap.put(goal, goalNode);
        }
        while (!queue.isEmpty()) {
            AStarRailNode node = (AStarRailNode)queue.remove();
            traversedRails.add(node.rail);
            if (node.rail == start) continue;
            AStarRailNode signalNode = firstSignals.get((Object)node.rail);
            if (signalNode != null) {
                int signalWeight = signalNode.distanceFromStart;
                firstSignals.remove((Object)node.rail);
                int totalWeight = signalWeight + node.distanceFromStart;
                if (totalWeight < bestDistance) {
                    bestDistance = totalWeight;
                    bestRoute = signalNode;
                    Log.debug("New best: " + signalWeight);
                }
                if (firstSignals.isEmpty()) {
                    Log.debug("No signals left: " + signalWeight);
                    break;
                }
                minSignalDistance = DestinationPathFinder.getClosestSignal(firstSignals);
                continue;
            }
            int minBound = minSignalDistance + node.distanceFromStart;
            if (minBound > bestDistance) break;
            for (Map.Entry<RailWrapper, EnumFacing> entry : node.rail.getNeighbors().entrySet()) {
                RailWrapper neighborRail = entry.getKey();
                if (TileEntitySignalBase.getNeighborSignal(neighborRail, entry.getValue().func_176734_d()) != null || traversedRails.contains((Object)neighborRail)) continue;
                AStarRailNode neighborNode = (AStarRailNode)railMap.get((Object)neighborRail);
                if (neighborNode == null) {
                    neighborNode = new AStarRailNode(neighborRail, entry.getValue(), start);
                    railMap.put(neighborRail, neighborNode);
                }
                if (!neighborNode.checkImprovementAndUpdate(node)) continue;
                queue.add(neighborNode);
            }
        }
        if (bestRoute != null) {
            AStarRailNode lastNode = bestRoute;
            while (lastNode.getNextNode() != null) {
                lastNode = lastNode.getNextNode();
            }
            lastNode.checkImprovementAndUpdate(new AStarRailNode(start, direction.func_176734_d(), start));
        }
        return bestRoute;
    }

    private static int getClosestSignal(Map<RailWrapper, AStarRailNode> signals) {
        int closest = Integer.MAX_VALUE;
        for (AStarRailNode node : signals.values()) {
            if (node.distanceFromStart >= closest) continue;
            closest = node.distanceFromStart;
        }
        return closest;
    }

    private static Map<RailWrapper, AStarRailNode> getFirstSignals(RailWrapper start, EnumFacing dir, Collection<RailWrapper> goals) {
        Object node;
        HashMap<RailWrapper, AStarRailNode> firstSignals = new HashMap<RailWrapper, AStarRailNode>();
        HashSet<RailWrapper> traversedRails = new HashSet<RailWrapper>();
        LinkedList<ImmutablePair> traversingRails = new LinkedList<ImmutablePair>();
        for (Map.Entry<RailWrapper, EnumFacing> entry : start.getNeighbors().entrySet()) {
            if (entry.getValue() == dir.func_176734_d()) continue;
            node = new AStarRailNode(entry.getKey(), entry.getValue(), null);
            ((AStarRailNode)node).distanceFromStart = 0;
            traversingRails.add(new ImmutablePair((Object)entry.getKey(), node));
        }
        traversedRails.add(start);
        while (!traversingRails.isEmpty()) {
            Map.Entry neighbor = (Map.Entry)traversingRails.poll();
            if (goals.contains(neighbor.getKey())) {
                firstSignals.clear();
                firstSignals.put((RailWrapper)((Object)neighbor.getKey()), (AStarRailNode)neighbor.getValue());
                Log.debug("Found destination without passing signals!");
                return firstSignals;
            }
            traversedRails.add((RailWrapper)((Object)neighbor.getKey()));
            TileEntitySignalBase signal = TileEntitySignalBase.getNeighborSignal((RailWrapper)((Object)neighbor.getKey()), ((AStarRailNode)neighbor.getValue()).pathDir.func_176734_d());
            if (signal == null) {
                if (((RailWrapper)((Object)neighbor.getKey())).getSignals().size() == 1) continue;
                for (Map.Entry entry : ((RailWrapper)((Object)neighbor.getKey())).getNeighbors().entrySet()) {
                    BlockPos nextNeighbor = (BlockPos)entry.getKey();
                    if (traversedRails.contains(nextNeighbor)) continue;
                    AStarRailNode nextNode = new AStarRailNode((RailWrapper)((Object)entry.getKey()), (EnumFacing)entry.getValue(), null);
                    nextNode.checkImprovementAndUpdate((AStarRailNode)neighbor.getValue());
                    traversingRails.add(new ImmutablePair(entry.getKey(), (Object)nextNode));
                }
                continue;
            }
            node = (AStarRailNode)neighbor.getValue();
            firstSignals.put((RailWrapper)((Object)neighbor.getKey()), (AStarRailNode)node);
            if (node == null || signal.getLampStatus() != BlockSignalBase.EnumLampStatus.RED) continue;
            Object object = node;
            ((AStarRailNode)object).distanceFromStart = ((AStarRailNode)object).distanceFromStart + 10000;
        }
        return firstSignals;
    }

    public static class AStarRailNode
    implements Comparable<AStarRailNode> {
        private int distanceFromStart = Integer.MAX_VALUE;
        private AStarRailNode prevNode;
        private final RailWrapper goal;
        private final RailWrapper rail;
        private final EnumFacing pathDir;

        public AStarRailNode(RailWrapper rail, EnumFacing pathDir, RailWrapper goal) {
            this.rail = rail;
            this.pathDir = pathDir;
            this.goal = goal;
        }

        public boolean checkImprovementAndUpdate(AStarRailNode node) {
            int nodeDist = node.distanceFromStart + 1;
            if (nodeDist < this.distanceFromStart) {
                this.prevNode = node;
                this.distanceFromStart = nodeDist;
                return true;
            }
            return false;
        }

        public AStarRailNode getNextNode() {
            return this.prevNode;
        }

        public RailWrapper getRail() {
            return this.rail;
        }

        private double getCost() {
            return (double)this.distanceFromStart + (this.goal != null ? this.getDistance(this.goal) : 0.0);
        }

        @Override
        public int compareTo(AStarRailNode node) {
            return Double.compare(this.getCost(), node.getCost());
        }

        private double getDistance(RailWrapper rail) {
            return Math.sqrt(this.rail.func_177951_i((Vec3i)rail));
        }
    }
}

