/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.minemaarten.signals.network.AbstractPacket;
import com.minemaarten.signals.rail.NetworkController;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class PacketUpdateNetworkController
extends AbstractPacket<PacketUpdateNetworkController> {
    private int[] colors;
    private int width;
    private int height;
    private int startX;
    private int startZ;
    private int dimension;

    public PacketUpdateNetworkController() {
    }

    public PacketUpdateNetworkController(int dimension, int[] colors, int width, int height, int startX, int startZ) {
        this.dimension = dimension;
        this.colors = colors;
        this.width = width;
        this.height = height;
        this.startX = startX;
        this.startZ = startZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.startX = buf.readInt();
        this.startZ = buf.readInt();
        this.colors = new int[this.width * this.height];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = buf.readInt();
        }
        this.dimension = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.writeInt(this.startX);
        buf.writeInt(this.startZ);
        for (int i : this.colors) {
            buf.writeInt(i);
        }
        buf.writeInt(this.dimension);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        NetworkController.getInstance(this.dimension, true).setColors(this.colors, this.width, this.height, this.startX, this.startZ);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

