/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketUpdateMinecartPath
extends AbstractPacket<PacketUpdateMinecartPath> {
    private NBTTagCompound path;
    private int cartId;

    public PacketUpdateMinecartPath() {
    }

    public PacketUpdateMinecartPath(EntityMinecart cart) {
        this.cartId = cart.func_145782_y();
        Capability<CapabilityMinecartDestination> i = CapabilityMinecartDestination.INSTANCE;
        this.path = (NBTTagCompound)i.getStorage().writeNBT(i, cart.getCapability(i, null), null);
    }

    public void fromBytes(ByteBuf buf) {
        this.cartId = buf.readInt();
        this.path = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.cartId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.path);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        CapabilityMinecartDestination cap;
        Entity entity = player.field_70170_p.func_73045_a(this.cartId);
        if (entity != null && (cap = (CapabilityMinecartDestination)entity.getCapability(CapabilityMinecartDestination.INSTANCE, null)) != null) {
            CapabilityMinecartDestination.INSTANCE.getStorage().readNBT(CapabilityMinecartDestination.INSTANCE, (Object)cap, null, (NBTBase)this.path);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

