/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.util;

import com.amadornes.rscircuits.util.RedstoneUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.Vector2d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class ProjectionHelper {
    public static Vec3d project(EnumFacing faceHit, double hitX, double hitY, double hitZ) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        switch (faceHit) {
            case DOWN: {
                x = -hitX;
                y = -hitY;
                z = hitZ;
                break;
            }
            case UP: {
                x = hitX;
                y = hitY;
                z = hitZ;
                break;
            }
            case NORTH: {
                x = hitX;
                y = -hitZ;
                z = hitY;
                break;
            }
            case SOUTH: {
                x = hitX;
                y = hitZ;
                z = 1.0 - hitY;
                break;
            }
            case WEST: {
                x = hitY;
                y = -hitX;
                z = hitZ;
                break;
            }
            case EAST: {
                x = 1.0 - hitY;
                y = hitX;
                z = hitZ;
                break;
            }
        }
        if (x < 0.0) {
            x = 1.0 + x;
        }
        if (y < 0.0) {
            y = 1.0 + y;
        }
        if (z < 0.0) {
            z = 1.0 + z;
        }
        return new Vec3d(x, y, z);
    }

    public static int getPlacementRotation(EnumFacing faceHit, double hitX, double hitY, double hitZ) {
        return ProjectionHelper.getPlacementRotation(ProjectionHelper.project(faceHit, hitX, hitY, hitZ));
    }

    public static int getPlacementRotation(Vec3d proj) {
        Vector2d projected = new Vector2d(proj.field_72450_a, proj.field_72449_c);
        projected.x -= 0.5;
        projected.y -= 0.5;
        if (projected.y > 0.0 && projected.y > Math.abs(projected.x)) {
            return 0;
        }
        if (projected.x > 0.0 && projected.x > Math.abs(projected.y)) {
            return 3;
        }
        if (projected.y < 0.0 && Math.abs(projected.y) > Math.abs(projected.x)) {
            return 2;
        }
        return 1;
    }

    public static AxisAlignedBB rotateFace(AxisAlignedBB box, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return box;
        }
        Vec3d min = RedstoneUtils.unproject(new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), facing);
        Vec3d max = RedstoneUtils.unproject(new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f), facing);
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public static AxisAlignedBB[] rotateFaces(AxisAlignedBB[] boxes, EnumFacing facing) {
        return ProjectionHelper.rotateFaces(Arrays.asList(boxes), facing).toArray(new AxisAlignedBB[boxes.length]);
    }

    public static List<AxisAlignedBB> rotateFaces(List<AxisAlignedBB> boxes, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return boxes;
        }
        return boxes.stream().map(b -> ProjectionHelper.rotateFace(b, facing)).collect(Collectors.toList());
    }
}

