/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import org.apache.commons.lang3.tuple.Pair;

public class ItemPool {
    private final Map<StackData, Integer> items;

    public ItemPool(ItemPool pool) {
        this.items = new HashMap<StackData, Integer>(pool.items);
    }

    public ItemPool() {
        this.items = new HashMap<StackData, Integer>();
    }

    public void add(ItemStack stack) {
        StackData data = new StackData(stack);
        this.items.merge(data, stack.field_77994_a, (a, b) -> (a == null ? 0 : a) + b);
    }

    public EnumActionResult remove(ItemStack stack) {
        StackData data = new StackData(stack);
        if (this.items.containsKey(stack)) {
            int size = this.items.merge(data, stack.field_77994_a, (a, b) -> (a == null ? 0 : a) - b);
            if (size <= 0) {
                this.items.remove(data);
            }
            return size >= 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public Pair<ItemStack, Integer> getFirstMissing(ItemPool pool) {
        for (Map.Entry<StackData, Integer> e : pool.items.entrySet()) {
            Integer amt = this.items.get(e.getKey());
            if (amt != null && amt >= e.getValue()) continue;
            return Pair.of((Object)e.getKey().stack, (Object)(e.getValue() - (amt == null ? 0 : amt)));
        }
        return null;
    }

    public boolean containsAll(ItemPool pool) {
        return this.getFirstMissing(pool) == null;
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        this.items.forEach((d, s) -> {
            ItemStack stack = ((StackData)d).stack;
            do {
                stack = stack.func_77946_l();
                stack.field_77994_a = Math.min(s, 64);
                list.add(stack);
            } while ((s = Integer.valueOf(s - 64)) > 0);
        });
        return list;
    }

    public Map<StackData, Integer> getRawItems() {
        return this.items;
    }

    public class StackData {
        private final ItemStack stack;

        public StackData(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.stack.func_77973_b().hashCode();
            result = 31 * result + this.stack.func_77952_i();
            result = 31 * result + (this.stack.func_77978_p() == null ? 0 : this.stack.func_77978_p().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            StackData other = (StackData)obj;
            return other.stack.func_77973_b() == this.stack.func_77973_b() && other.stack.func_77952_i() == this.stack.func_77952_i() && (this.stack.func_77942_o() ? other.stack.func_77942_o() && this.stack.func_77978_p().equals((Object)other.stack.func_77978_p()) : !other.stack.func_77942_o());
        }
    }
}

