/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.part;

import com.amadornes.rscircuits.SCM;
import com.amadornes.rscircuits.api.circuit.EnumCircuitIOMode;
import com.amadornes.rscircuits.api.circuit.ExternalCircuitException;
import com.amadornes.rscircuits.api.circuit.HandledCircuitException;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.circuit.Circuit;
import com.amadornes.rscircuits.circuit.EnumCircuitCrashStatus;
import com.amadornes.rscircuits.circuit.ICircuitContainer;
import com.amadornes.rscircuits.client.AdvancedEntityDiggingFX;
import com.amadornes.rscircuits.client.MSRCircuit;
import com.amadornes.rscircuits.component.ComponentRegistry;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.network.NetworkHandler;
import com.amadornes.rscircuits.network.PacketCustomPayload;
import com.amadornes.rscircuits.network.PacketSpawnMagicSmoke;
import com.amadornes.rscircuits.util.ItemPool;
import com.amadornes.rscircuits.util.ProjectionHelper;
import com.amadornes.rscircuits.util.RedstoneUtils;
import com.amadornes.rscircuits.util.UnlistedPropertyComponentStates;
import com.amadornes.rscircuits.util.UnlistedPropertyIOModes;
import com.amadornes.rscircuits.util.UnlistedPropertyName;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import mcmultipart.MCMultiPartMod;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.client.multipart.ICustomHighlightPart;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.IRedstonePart;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.BufferUtils;

public class PartCircuit
extends Multipart
implements ISlottedPart,
INormallyOccludingPart,
ICustomHighlightPart,
ITickable,
IRedstonePart.ISlottedRedstonePart,
ICircuitContainer {
    public static final float OFFSET = 0.125f;
    public static float selectionBoxOffset = 0.0f;
    public static final IProperty<Boolean> PROPERTY_CAPSULE = PropertyBool.func_177716_a((String)"capsule");
    public static final IProperty<Boolean> PROPERTY_SAD = PropertyBool.func_177716_a((String)"sad");
    public static final IUnlistedProperty<Map<BlockPos, List<Triple<IBlockState, IBlockState, Triple<Float, Vec3d, IntUnaryOperator>>>>> PROPERTY_COMPONENTS = new UnlistedPropertyComponentStates();
    public static final IUnlistedProperty<String> PROPERTY_NAME = new UnlistedPropertyName();
    public static final IUnlistedProperty<EnumCircuitIOMode[]> PROPERTY_IO_MODE = new UnlistedPropertyIOModes();
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private EnumFacing face;
    public Circuit circuit = new Circuit(this);
    private boolean isEncapsulated = false;
    private boolean isSad = false;
    private boolean notifyAdded;
    private boolean notifyRemoved;
    @SideOnly(value=Side.CLIENT)
    private FloatBuffer buf;

    public PartCircuit(EnumFacing face, NBTTagCompound tag) {
        if (tag != null) {
            this.readFromNBT(tag);
        }
        this.face = face;
    }

    public PartCircuit() {
    }

    @Override
    public boolean isInWorld() {
        return true;
    }

    @Override
    public EnumFacing getFace() {
        return this.face;
    }

    public Material getMaterial() {
        return Material.field_151576_e;
    }

    public float getHardness(PartMOP hit) {
        return 1.0f;
    }

    public String getHarvestTool() {
        return "pickaxe";
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.getFaceSlot((EnumFacing)this.face));
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        list.add(BOXES[this.face.ordinal()]);
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB box = BOXES[this.face.ordinal()];
        if (box.func_72326_a(mask)) {
            list.add(box);
        }
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(BOXES[this.face.ordinal()]);
        if (selectionBoxOffset != 0.0f) {
            list.add(new AxisAlignedBB(this.face == EnumFacing.WEST ? 0.125 + (double)selectionBoxOffset : (this.face == EnumFacing.EAST ? 0.875 - (double)selectionBoxOffset : 0.0), this.face == EnumFacing.DOWN ? 0.125 + (double)selectionBoxOffset : (this.face == EnumFacing.UP ? 0.875 - (double)selectionBoxOffset : 0.0), this.face == EnumFacing.NORTH ? 0.125 + (double)selectionBoxOffset : (this.face == EnumFacing.SOUTH ? 0.875 - (double)selectionBoxOffset : 0.0), this.face == EnumFacing.WEST ? 0.125 + (double)selectionBoxOffset : (this.face == EnumFacing.EAST ? 0.875 - (double)selectionBoxOffset : 1.0), this.face == EnumFacing.DOWN ? 0.125 + (double)selectionBoxOffset : (this.face == EnumFacing.UP ? 0.875 - (double)selectionBoxOffset : 1.0), this.face == EnumFacing.NORTH ? 0.125 + (double)selectionBoxOffset : (this.face == EnumFacing.SOUTH ? 0.875 - (double)selectionBoxOffset : 1.0)));
        }
    }

    public boolean occlusionTest(IMultipart part) {
        return !(part instanceof PartCircuit) && super.occlusionTest(part);
    }

    public RayTraceUtils.AdvancedRayTraceResultPart collisionRayTrace(Vec3d start, Vec3d end) {
        RayTraceUtils.AdvancedRayTraceResultPart defRT = super.collisionRayTrace(start, end);
        if (selectionBoxOffset != 0.0f) {
            return defRT;
        }
        RayTraceUtils.AdvancedRayTraceResult hit = null;
        double dist = Double.POSITIVE_INFINITY;
        if (defRT != null) {
            hit = new RayTraceUtils.AdvancedRayTraceResult(defRT.hit, defRT.bounds);
            dist = ((PartMOP)defRT.hit).field_72307_f.func_72436_e(start);
        }
        if (!this.isEncapsulated && !this.isSad) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = -1; x < 8; ++x) {
                int x_ = x;
                for (int y = 0; y < 5; ++y) {
                    int y_ = y;
                    for (int z = -1; z < 8; ++z) {
                        int z_ = z;
                        for (EnumComponentSlot slot : EnumComponentSlot.VALUES) {
                            double d;
                            pos.func_181079_c(x, y, z);
                            IComponent c = this.circuit.getComponent((BlockPos)pos, slot);
                            if (c == null || c.getCircuit().isEncapsulated()) continue;
                            c.addSelectionBoxes(list);
                            list.replaceAll(bb -> new AxisAlignedBB(bb.field_72340_a * 2.0 / 16.0, bb.field_72338_b * 2.0 / 16.0, bb.field_72339_c * 2.0 / 16.0, bb.field_72336_d * 2.0 / 16.0, bb.field_72337_e * 2.0 / 16.0, bb.field_72334_f * 2.0 / 16.0).func_72317_d((double)(2 * x_ + 1) / 16.0, (double)(2 * (y_ + 1)) / 16.0, (double)(2 * z_ + 1) / 16.0));
                            RayTraceUtils.AdvancedRayTraceResult result = RayTraceUtils.collisionRayTrace((World)this.getWorld(), (BlockPos)this.getPos(), (Vec3d)start, (Vec3d)end, ProjectionHelper.rotateFaces(list, this.getFace()));
                            if (result != null && (d = result.hit.field_72307_f.func_72436_e(start)) <= dist) {
                                AxisAlignedBB newHitBox = c.getSelectionBox(result.bounds);
                                if (newHitBox != result.bounds) {
                                    newHitBox = ProjectionHelper.rotateFace(new AxisAlignedBB(newHitBox.field_72340_a * 2.0 / 16.0, newHitBox.field_72338_b * 2.0 / 16.0, newHitBox.field_72339_c * 2.0 / 16.0, newHitBox.field_72336_d * 2.0 / 16.0, newHitBox.field_72337_e * 2.0 / 16.0, newHitBox.field_72334_f * 2.0 / 16.0).func_72317_d(0.0625 + 0.125 * (double)x_, 0.125 * (double)(y_ + 1), 0.0625 + 0.125 * (double)z_), this.getFace());
                                    hit = new RayTraceUtils.AdvancedRayTraceResult(result.hit, newHitBox);
                                } else {
                                    hit = result;
                                }
                                hit.hit.hitInfo = c;
                                dist = d;
                            }
                            list.clear();
                        }
                    }
                }
            }
        }
        return hit != null ? new RayTraceUtils.AdvancedRayTraceResultPart(hit, (IMultipart)this) : null;
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)MCMultiPartMod.multipart).add(new IProperty[]{BlockDirectional.field_176387_N, PROPERTY_CAPSULE, PROPERTY_SAD}).add(new IUnlistedProperty[]{PROPERTY_COMPONENTS, PROPERTY_NAME}).add(new IUnlistedProperty[]{PROPERTY_IO_MODE}).build();
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)this.face).func_177226_a(PROPERTY_CAPSULE, (Comparable)Boolean.valueOf(this.isEncapsulated && !this.isSad)).func_177226_a(PROPERTY_SAD, (Comparable)Boolean.valueOf(this.isSad));
    }

    public IBlockState getExtendedState(IBlockState state) {
        HashMap states = new HashMap();
        if (!this.isEncapsulated && !this.isSad) {
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 5; ++y) {
                    for (int z = 0; z < 8; ++z) {
                        ArrayList<Triple> l = null;
                        for (int s = 0; s < 7; ++s) {
                            IBlockState actualState;
                            IComponent c = this.circuit.components[x][y][z][s];
                            if (c == null || c.isDynamic() || (actualState = c.getActualState()) == null) continue;
                            IBlockState extendedState = c.getExtendedState(actualState);
                            if (l == null) {
                                l = new ArrayList<Triple>();
                                states.put(new BlockPos(x, y, z), l);
                            }
                            l.add(Triple.of((Object)actualState, (Object)extendedState, (Object)Triple.of((Object)Float.valueOf(c.getSize()), (Object)c.getOffset(), c::getColorMultiplier)));
                        }
                    }
                }
            }
        }
        return ((IExtendedBlockState)state).withProperty(PROPERTY_COMPONENTS, states).withProperty(PROPERTY_NAME, (Object)this.circuit.getName()).withProperty(PROPERTY_IO_MODE, (Object)this.circuit.getIOModes());
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, PartMOP hit) {
        if (this.isSad) {
            if (heldItem != null && heldItem.func_77973_b() == SCMItems.multimeter) {
                if (!this.getWorld().field_72995_K) {
                    Pair<EnumCircuitCrashStatus, String> crash = this.circuit.getCrash();
                    player.func_145747_a((ITextComponent)new TextComponentString("Crash status: " + crash.getKey()));
                    if (crash.getKey() == EnumCircuitCrashStatus.UPLOADED) {
                        player.func_145747_a(ForgeHooks.newChatWithLinks((String)(" Log URL: " + (String)crash.getValue())));
                    } else if (crash.getKey() == EnumCircuitCrashStatus.UPLOAD_ERROR) {
                        player.func_145747_a((ITextComponent)new TextComponentString(" File name: " + (String)crash.getValue()));
                    }
                }
                return true;
            }
            return false;
        }
        if (this.isEncapsulated && !player.func_70093_af() && heldItem != null && heldItem.func_77973_b() == SCMItems.screwdriver) {
            Vec3d hitPos = hit.field_72307_f.func_178788_d(new Vec3d((Vec3i)hit.func_178782_a()));
            Vec3d proj = ProjectionHelper.project(this.face, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c);
            Vec3d nProj = new Vec3d(0.5 - Math.abs(proj.field_72450_a - 0.5), 0.0, 0.5 - Math.abs(proj.field_72449_c - 0.5));
            if (nProj.field_72450_a > 0.25 && nProj.field_72449_c >= 0.0625 && nProj.field_72449_c < 0.1875 || nProj.field_72449_c > 0.25 && nProj.field_72450_a >= 0.0625 && nProj.field_72450_a < 0.1875) {
                if (!this.getWorld().field_72995_K) {
                    int quadrant = 6 - ProjectionHelper.getPlacementRotation(proj);
                    switch (this.getFace()) {
                        case DOWN: 
                        case WEST: {
                            break;
                        }
                        case UP: 
                        case EAST: {
                            quadrant -= 2;
                            break;
                        }
                        case NORTH: {
                            ++quadrant;
                            break;
                        }
                        case SOUTH: {
                            --quadrant;
                        }
                    }
                    quadrant %= 4;
                    if (this.getFace().func_176740_k() != EnumFacing.Axis.Y) {
                        quadrant = quadrant == 3 ? 2 : (quadrant == 2 ? 1 : (quadrant == 1 ? 3 : 0));
                    }
                    this.circuit.cycleModes(EnumCircuitSide.HORIZONTALS_ROT[quadrant]);
                }
                return true;
            }
        } else {
            IComponent comp = (IComponent)hit.hitInfo;
            if (comp != null && ((Circuit)comp.getCircuit()).canInteractWith(comp)) {
                Vec3d hitPos = RedstoneUtils.projectComponent(new Vec3d(hit.field_72307_f.field_72450_a - (double)comp.getCircuit().getPos().func_177958_n(), hit.field_72307_f.field_72448_b - (double)comp.getCircuit().getPos().func_177956_o(), hit.field_72307_f.field_72449_c - (double)comp.getCircuit().getPos().func_177952_p()), this.getFace(), comp.getPos());
                try {
                    if (comp.onActivated(player, hand, heldItem, hitPos)) {
                        return true;
                    }
                }
                catch (ExternalCircuitException e) {
                    throw Throwables.propagate((Throwable)e.getOriginalThrowable());
                }
                catch (HandledCircuitException e) {
                    if (!this.getWorld().field_72995_K) {
                        this.isSad = true;
                        this.sendUpdatePacket();
                    }
                    SCM.log.error("Error while interacting with circuit.", (Throwable)e);
                    this.circuit.onCrash(e);
                }
                catch (Throwable e) {
                    if (!this.getWorld().field_72995_K) {
                        this.isSad = true;
                        this.sendUpdatePacket();
                    }
                    this.spawnMagicSmoke(comp.getPos());
                    SCM.log.error("Error while interacting with circuit.", e);
                    this.circuit.onCrash(e);
                }
                if (heldItem != null && heldItem.func_77973_b() == SCMItems.multimeter) {
                    if (!this.getWorld().field_72995_K) {
                        comp.debug(player);
                    }
                    return true;
                }
                return false;
            }
        }
        if (heldItem != null && heldItem.func_77973_b() == SCMItems.multimeter) {
            if (!this.getWorld().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Circuit complexity: " + (this.circuit.computeComplexity() + 0.25f)));
            }
            return true;
        }
        if (heldItem != null && heldItem.func_77973_b() == SCMItems.squeegee && (player instanceof FakePlayer || player.func_70093_af())) {
            if (!this.getWorld().field_72995_K) {
                ItemPool pool = new ItemPool();
                this.circuit.forEach(c -> c.getDrops().forEach(pool::add));
                World world = this.getWorld();
                int x = this.getPos().func_177958_n();
                int y = this.getPos().func_177956_o();
                int z = this.getPos().func_177952_p();
                if (player instanceof FakePlayer) {
                    pool.getItems().forEach(s -> InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)s));
                } else {
                    pool.getItems().forEach(s -> {
                        if (!player.field_71071_by.func_70441_a(s)) {
                            InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)s);
                        }
                    });
                }
                this.circuit.clear();
            }
            return true;
        }
        if (hand == EnumHand.MAIN_HAND && heldItem != null && heldItem.func_77973_b() == SCMItems.screwdriver) {
            if (player.func_70093_af()) {
                if (!this.getWorld().field_72995_K) {
                    this.isEncapsulated = !this.isEncapsulated;
                    this.sendUpdatePacket();
                }
            } else {
                if (this.isEncapsulated()) {
                    return false;
                }
                if (!this.getWorld().field_72995_K) {
                    this.circuit.rotate(Rotation.CLOCKWISE_90);
                    this.markDirty();
                    this.notifyNeighbors();
                    this.notifyPartUpdate();
                }
            }
            return true;
        }
        return false;
    }

    public void onClicked(EntityPlayer player, PartMOP hit) {
        this.click(player, hit);
    }

    public void harvest(EntityPlayer player, PartMOP hit) {
        if (player != null && hit != null && this.click(player, hit)) {
            return;
        }
        if (player == null || !player.field_71075_bZ.field_75098_d || player.func_70093_af() || this.circuit.isEmpty()) {
            super.harvest(player, hit);
        }
    }

    protected boolean click(EntityPlayer player, PartMOP hit) {
        if (this.isSad) {
            return false;
        }
        if (player != null && hit != null && hit.hitInfo != null && hit.hitInfo instanceof IComponent) {
            IComponent comp = (IComponent)hit.hitInfo;
            Vec3d hitPos = RedstoneUtils.projectComponent(new Vec3d(hit.field_72307_f.field_72450_a - (double)comp.getCircuit().getPos().func_177958_n(), hit.field_72307_f.field_72448_b - (double)comp.getCircuit().getPos().func_177956_o(), hit.field_72307_f.field_72449_c - (double)comp.getCircuit().getPos().func_177952_p()), this.getFace(), comp.getPos());
            if (comp.harvest(player, hitPos) && !player.field_71075_bZ.field_75098_d) {
                comp.getDrops().forEach(stack -> Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)stack));
            }
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (this.isSad) {
            if (this.getWorld().field_72995_K && Math.random() < 0.5) {
                this.spawnMagicSmoke(new Vec3d(Math.random() * 7.0, 0.0, Math.random() * 7.0));
            }
            return;
        }
        try {
            if (this.notifyRemoved) {
                this.circuit.forEach(IComponent::onCircuitRemoved);
                this.notifyRemoved = false;
            } else if (this.notifyAdded) {
                this.circuit.forEach(IComponent::onLoaded);
                this.circuit.forEach(IComponent::onCircuitAdded);
                this.notifyAdded = false;
            }
            this.circuit.tickScheduled();
            this.circuit.tick();
            this.circuit.tickEnd();
        }
        catch (ExternalCircuitException e) {
            throw Throwables.propagate((Throwable)e.getOriginalThrowable());
        }
        catch (HandledCircuitException e) {
            if (!this.getWorld().field_72995_K) {
                this.isSad = true;
                this.sendUpdatePacket();
            }
            SCM.log.error("Error while updating circuit.", (Throwable)e);
            this.circuit.onCrash(e);
        }
        catch (Throwable e) {
            if (!this.getWorld().field_72995_K) {
                this.isSad = true;
                this.sendUpdatePacket();
            }
            this.spawnMagicSmoke(this.getPos());
            SCM.log.error("Error while updating circuit.", e);
            this.circuit.onCrash(e);
        }
    }

    public void onNeighborBlockChange(Block block) {
        if (this.isSad) {
            return;
        }
        if (!this.getWorld().isSideSolid(this.getPos().func_177972_a(this.getFace()), this.getFace().func_176734_d())) {
            this.harvest(null, null);
            return;
        }
        for (EnumCircuitSide side : EnumCircuitSide.HORIZONTALS) {
            this.circuit.forEachEdge(IComponent::onWorldChange, side, 0, 0, EnumComponentSlot.VALUES);
        }
    }

    public void onNeighborTileChange(EnumFacing facing) {
        if (this.isSad) {
            return;
        }
        this.circuit.forEachEdge(IComponent::onWorldTileChange, RedstoneUtils.convert(this.getFace(), facing), 0, 0, EnumComponentSlot.VALUES);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean drawHighlight(PartMOP hit, EntityPlayer player, float partialTicks) {
        IComponentFactory<?> factory;
        if (this.isEncapsulated) {
            ItemStack heldItem = RedstoneUtils.unwrap(player.func_184614_ca());
            if (heldItem != null && heldItem.func_77973_b() == SCMItems.screwdriver) {
                Vec3d hitPos = hit.field_72307_f.func_178788_d(new Vec3d((Vec3i)hit.func_178782_a()));
                Vec3d proj = ProjectionHelper.project(this.face, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c);
                Vec3d nProj = new Vec3d(0.5 - Math.abs(proj.field_72450_a - 0.5), 0.0, 0.5 - Math.abs(proj.field_72449_c - 0.5));
                if (nProj.field_72450_a > 0.25 && nProj.field_72449_c >= 0.0625 && nProj.field_72449_c < 0.1875 || nProj.field_72449_c > 0.25 && nProj.field_72450_a >= 0.0625 && nProj.field_72450_a < 0.1875) {
                    int quadrant = 6 - ProjectionHelper.getPlacementRotation(proj);
                    switch (this.getFace()) {
                        case DOWN: 
                        case WEST: {
                            break;
                        }
                        case UP: 
                        case EAST: {
                            quadrant -= 2;
                            break;
                        }
                        case NORTH: {
                            ++quadrant;
                            break;
                        }
                        case SOUTH: {
                            --quadrant;
                        }
                    }
                    Matrix4f mat = ModelRotation.func_177524_a((int)0, (int)((quadrant %= 4) * 90)).getMatrix();
                    Point3f p1 = new Point3f(0.25f, 0.0625f, 0.0625f);
                    Point3f p2 = new Point3f(0.75f, 0.127f, 0.203125f);
                    mat.transform(p1);
                    mat.transform(p2);
                    AxisAlignedBB bb = new AxisAlignedBB((double)p1.x, (double)p1.y, (double)p1.z, (double)p2.x, (double)p2.y, (double)p2.z);
                    GlStateManager.func_179094_E();
                    if (this.buf == null) {
                        this.buf = BufferUtils.createFloatBuffer((int)16);
                    }
                    this.buf.rewind();
                    TRSRTransformation.toLwjgl((Matrix4f)MSRCircuit.matrices[this.getFace().ordinal()]).store(this.buf);
                    this.buf.flip().rewind();
                    GlStateManager.func_179110_a((FloatBuffer)this.buf);
                    this.drawAABB(bb);
                    GlStateManager.func_179121_F();
                    return true;
                }
            }
            return false;
        }
        if (this.isSad) {
            return false;
        }
        ItemStack heldItem = RedstoneUtils.unwrap(player.func_184614_ca());
        if (heldItem != null && (factory = ComponentRegistry.INSTANCE.getFactory(heldItem, player)) != null) {
            Circuit circuit;
            Vec3d extrudedProjection = RedstoneUtils.projectComponent(new Vec3d(hit.field_72307_f.field_72450_a - (double)this.getPos().func_177958_n(), hit.field_72307_f.field_72448_b - (double)this.getPos().func_177956_o(), hit.field_72307_f.field_72449_c - (double)this.getPos().func_177952_p()), this.getFace(), BlockPos.field_177992_a);
            BlockPos clickedPos = new BlockPos(extrudedProjection);
            if (hit.hitInfo != null && hit.hitInfo instanceof IComponent && ((IComponent)hit.hitInfo).getPos().equals((Object)clickedPos)) {
                Vec3d subPos = extrudedProjection.func_178788_d(new Vec3d((Vec3i)clickedPos));
                if (subPos.field_72450_a == 0.0) {
                    clickedPos = clickedPos.func_177982_a(-1, 0, 0);
                } else if (subPos.field_72449_c == 0.0) {
                    clickedPos = clickedPos.func_177982_a(0, 0, -1);
                }
            }
            if ((circuit = this.circuit.getCircuit(clickedPos)) != null) {
                clickedPos = RedstoneUtils.limitPositionToBounds(clickedPos);
                double border = 0.0625;
                double cellSize = 0.14285714285714285;
                double height = 0.125;
                double d = 0.002 / (1.0 - 2.0 * border);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(circuit.getPos().func_177958_n() - this.getPos().func_177958_n()), (float)(circuit.getPos().func_177956_o() - this.getPos().func_177956_o()), (float)(circuit.getPos().func_177952_p() - this.getPos().func_177952_p()));
                if (this.buf == null) {
                    this.buf = BufferUtils.createFloatBuffer((int)16);
                }
                this.buf.rewind();
                TRSRTransformation.toLwjgl((Matrix4f)MSRCircuit.matrices[this.getFace().ordinal()]).store(this.buf);
                this.buf.flip().rewind();
                GlStateManager.func_179110_a((FloatBuffer)this.buf);
                GlStateManager.func_179137_b((double)border, (double)height, (double)border);
                GlStateManager.func_179139_a((double)((1.0 - 2.0 * border) * cellSize), (double)((1.0 - 2.0 * border) * cellSize), (double)((1.0 - 2.0 * border) * cellSize));
                GlStateManager.func_179109_b((float)clickedPos.func_177958_n(), (float)clickedPos.func_177956_o(), (float)clickedPos.func_177952_p());
                this.drawComponentHighlight(player, heldItem, factory, extrudedProjection, clickedPos, circuit);
                this.drawAABB(new AxisAlignedBB(0.0 - d, (double)(-clickedPos.func_177956_o()), 0.0 - d, 1.0 + d, d, 1.0 + d));
                GlStateManager.func_179121_F();
            }
        }
        return false;
    }

    public void drawAABB(AxisAlignedBB bb) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        RenderGlobal.func_189697_a((AxisAlignedBB)bb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private <T> void drawComponentHighlight(EntityPlayer player, ItemStack heldItem, IComponentFactory<T> factory, Vec3d extrudedProjection, BlockPos clickedPos, Circuit circuit) {
        IComponentFactory.EnumPlacementType type = factory.getPlacementType(heldItem, player);
        Object data = factory.getPlacementData(circuit, clickedPos, EnumCircuitSide.BOTTOM, extrudedProjection, heldItem, player, type, null, Collections.emptyMap(), IComponentFactory.EnumInstantanceUse.RENDER);
        if (data != null && factory.placeComponent(circuit, clickedPos, data, type, Collections.emptyMap(), true)) {
            GlStateManager.func_179088_q();
            GlStateManager.func_179136_a((float)0.1f, (float)0.1f);
            factory.drawPlacement(circuit, clickedPos, data, type, Collections.emptyMap());
            GlStateManager.func_179113_r();
        }
    }

    public boolean addDestroyEffects(AdvancedParticleManager particleManager) {
        RayTraceResult mop = SCM.proxy.getHit();
        if (mop instanceof PartMOP) {
            PartMOP hit = (PartMOP)mop;
            if (hit.partHit == this) {
                IComponent component = (IComponent)hit.hitInfo;
                if (component == null) {
                    EntityPlayer player = SCM.proxy.getPlayer();
                    if (player.field_71075_bZ.field_75098_d && !player.func_70093_af() && !this.circuit.isEmpty()) {
                        return true;
                    }
                } else {
                    TextureAtlasSprite icon;
                    IBakedModel model;
                    IBlockState state = component.getActualState();
                    if (state != null && (model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state)) != null && (icon = model.func_177554_e()) != null) {
                        World world = this.getWorld();
                        BlockPos pos = this.getPos();
                        Vec3d cpos = RedstoneUtils.unproject(new Vec3d((Vec3i)component.getPos()).func_72441_c(0.25, 0.25, 0.25).func_186678_a(0.125).func_72441_c(0.0625, 0.125, 0.0625), this.getFace());
                        int i = 2;
                        for (int j = 0; j < i; ++j) {
                            for (int k = 0; k < i; ++k) {
                                for (int l = 0; l < i; ++l) {
                                    double d0 = (double)pos.func_177958_n() + cpos.field_72450_a + ((double)j + 0.5) / (double)(i * 8);
                                    double d1 = (double)pos.func_177956_o() + cpos.field_72448_b + ((double)k + 0.5) / (double)(i * 8);
                                    double d2 = (double)pos.func_177952_p() + cpos.field_72449_c + ((double)l + 0.5) / (double)(i * 8);
                                    particleManager.func_78873_a(new AdvancedEntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, icon).func_174846_a(pos).func_70541_f(0.25f).func_70543_e(0.5f));
                                }
                            }
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void onAdded() {
        this.notifyAdded = true;
    }

    public void onRemoved() {
        this.notifyRemoved = true;
    }

    public void onLoaded() {
        this.notifyAdded = true;
    }

    public void onUnloaded() {
        this.notifyRemoved = true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("face", this.face.ordinal());
        tag.func_74757_a("isEncapsulated", this.isEncapsulated);
        tag.func_74757_a("isSad", this.isSad);
        return this.circuit.writeToNBT(tag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.face = EnumFacing.func_82600_a((int)tag.func_74762_e("face"));
        this.isEncapsulated = tag.func_74767_n("isEncapsulated");
        this.isSad = tag.func_74767_n("isSad");
        this.circuit.readFromNBT(tag);
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.face);
        buf.writeBoolean(this.isEncapsulated);
        buf.writeBoolean(this.isSad);
        this.circuit.writeUpdatePacket(buf);
    }

    public void readUpdatePacket(PacketBuffer buf) {
        this.face = (EnumFacing)buf.func_179257_a(EnumFacing.class);
        this.isEncapsulated = buf.readBoolean();
        this.isSad = buf.readBoolean();
        this.circuit.readUpdatePacket(buf);
    }

    @Override
    public boolean isEncapsulated() {
        return this.isEncapsulated;
    }

    public boolean isSad() {
        return this.isSad;
    }

    @Override
    public void notifyNeighbors() {
        if (this.isSad) {
            return;
        }
        this.notifyBlockUpdate();
    }

    @Override
    public void notifyNeighbor(EnumCircuitSide side, boolean strong) {
        IBlockState state;
        if (this.isSad) {
            return;
        }
        EnumFacing s = RedstoneUtils.convert(this.getFace(), side);
        BlockPos pos = this.getPos().func_177972_a(s);
        this.getWorld().func_180496_d(pos, (Block)MCMultiPartMod.multipart);
        if (strong && (state = this.getWorld().func_180495_p(pos)).func_177230_c().shouldCheckWeakPower(state, (IBlockAccess)this.getWorld(), pos, s)) {
            this.getWorld().func_175695_a(pos, state.func_177230_c(), s.func_176734_d());
        }
    }

    @Override
    public byte getInput(EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        ISlottedPart part;
        if (this.getWorld() == null || this.getPos() == null || this.isSad) {
            return 0;
        }
        if (bundled) {
            return 0;
        }
        EnumFacing f = RedstoneUtils.convert(this.getFace(), side);
        IBlockState state = this.getWorld().func_180495_p(this.getPos().func_177972_a(f));
        if (state.func_177230_c() == Blocks.field_150488_af) {
            return (byte)((Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) * 17);
        }
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(f));
        if (container != null && (part = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)this.getFace()))) != null && part instanceof PartCircuit) {
            return 0;
        }
        return (byte)(this.getWorld().func_175651_c(this.getPos().func_177972_a(f), f) * 17);
    }

    public boolean canConnectRedstone(EnumFacing side) {
        return side != this.getFace() && side != this.getFace().func_176734_d();
    }

    public int getWeakSignal(EnumFacing side) {
        if (this.isSad || !this.canConnectRedstone(side)) {
            return 0;
        }
        EnumCircuitSide s = RedstoneUtils.convert(this.getFace(), side);
        return (this.circuit.getOutput(s, null, false) & 0xFF) / 17;
    }

    public int getStrongSignal(EnumFacing side) {
        return this.getWeakSignal(side);
    }

    public ItemStack getStack() {
        ItemStack stack = new ItemStack(SCMItems.circuit);
        try {
            if (!this.circuit.isEmpty()) {
                NBTTagCompound tag = new NBTTagCompound();
                this.circuit.writeToNBT(tag);
                tag.func_74776_a("complexity", this.circuit.computeComplexity());
                stack.func_77982_d(tag);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return stack;
    }

    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getStack());
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        if (hit != null && hit.hitInfo != null && hit.hitInfo instanceof IComponent) {
            return ((IComponent)hit.hitInfo).getPickedItem();
        }
        ItemStack stack = this.getStack();
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74772_a("circPos", this.getPos().func_177986_g());
            stack.func_77978_p().func_74768_a("circDim", this.getWorld().field_73011_w.getDimension());
        }
        return stack;
    }

    @Override
    public void markDirty() {
        super.markDirty();
    }

    @Override
    public void markRenderUpdate() {
        super.markRenderUpdate();
    }

    @Override
    public Circuit getCircuitAt(BlockPos pos, EnumFacing face) {
        PartCircuit c = PartCircuit.getCircuitAt(this.getWorld(), pos, face);
        return c != null ? c.circuit : null;
    }

    @Override
    public void sendCustomPayload(BlockPos pos, EnumComponentSlot slot, ByteBuf buf) {
        if (this.isSad) {
            return;
        }
        NetworkHandler.instance.sendToServer(new PacketCustomPayload(this, pos, slot, buf.array()));
    }

    public static PartCircuit getCircuitAt(World world, BlockPos pos, EnumFacing face) {
        ISlottedPart m;
        IMultipartContainer c = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (c != null && (m = c.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)face))) != null & m instanceof PartCircuit) {
            return (PartCircuit)m;
        }
        return null;
    }

    @Override
    public void spawnMagicSmoke(BlockPos compPos) {
        this.spawnMagicSmoke(new Vec3d((Vec3i)compPos));
    }

    public void spawnMagicSmoke(Vec3d compPos) {
        Vec3d pos = RedstoneUtils.unproject(compPos.func_72441_c(0.5, 1.0, 0.5).func_186678_a(0.125), this.face).func_178787_e(new Vec3d((Vec3i)this.getPos()));
        if (this.getWorld().field_72995_K) {
            double rnd = Math.random();
            if (rnd <= 0.3333333333333333) {
                this.getWorld().func_175688_a(EnumParticleTypes.CLOUD, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            } else if (rnd <= 0.6666666666666666) {
                this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, -5.0, 0.0, new int[0]);
            } else {
                this.getWorld().func_175688_a(EnumParticleTypes.SNOW_SHOVEL, pos.field_72450_a, pos.field_72448_b + 0.1, pos.field_72449_c, 0.0, 0.075, 0.0, new int[0]);
            }
        } else {
            NetworkHandler.instance.sendToAllAround(new PacketSpawnMagicSmoke(pos), new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.getDimension(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 64.0));
        }
    }

    @Override
    public void spawnStack(ItemStack stack) {
        BlockPos pos = this.getPos();
        InventoryHelper.func_180173_a((World)this.getWorld(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
    }

    @Override
    public void onCleared() {
        this.isSad = false;
        this.sendUpdatePacket();
    }
}

