/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.misc;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.api.component.IWirePassthroughComponent;
import com.amadornes.rscircuits.component.ComponentFace;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.amadornes.rscircuits.part.PartCircuit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ComponentPlate
extends ComponentFace
implements IWirePassthroughComponent {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "plate");

    public ComponentPlate(ICircuit circuit) {
        super(circuit, EnumComponentSlot.TOP);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.001f;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        if (side == slot.side) {
            IComponent component = this.getCircuit().getComponent(this.getPos(), EnumComponentSlot.CENTER);
            return component != null ? component.isOutput(EnumComponentSlot.CENTER, side) : false;
        }
        return false;
    }

    @Override
    public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        if (side == slot.side) {
            IComponent component = this.getCircuit().getComponent(this.getPos(), EnumComponentSlot.CENTER);
            return component != null ? component.isStrongOutput(EnumComponentSlot.CENTER, side) : false;
        }
        return false;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        if (side == slot.side) {
            IComponent component = this.getCircuit().getComponent(this.getPos(), EnumComponentSlot.CENTER);
            return component != null ? component.getOutputSignal(EnumComponentSlot.CENTER, side, color, bundled) : (byte)0;
        }
        return 0;
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        IComponent c;
        if (side == EnumCircuitSide.BOTTOM) {
            IComponent c2 = this.getCircuit().getComponent(this.getPos().func_177984_a(), EnumComponentSlot.BOTTOM);
            if (c2 != null) {
                c2.onNeighborChange(side, slot, component, updateType);
            }
        } else if (side == EnumCircuitSide.TOP && (c = this.getCircuit().getComponent(this.getPos(), EnumComponentSlot.CENTER)) != null) {
            c.onNeighborChange(side, slot, component, updateType);
        }
    }

    @Override
    public boolean isSideSolid(EnumCircuitSide side) {
        return true;
    }

    @Override
    public boolean blocksWire() {
        return false;
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.TINY_PLATE.ordinal());
    }

    public static class Factory
    extends SimpleFactory<ComponentPlate>
    implements IComponentFactory.IDrawListener<ComponentPlate> {
        private int height = -1;

        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[0]);
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/plate");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.TINY_PLATE.ordinal();
        }

        @Override
        public IComponentFactory.EnumPlacementType getPlacementType(ItemStack stack, EntityPlayer player) {
            return IComponentFactory.EnumPlacementType.DRAW;
        }

        @Override
        public ComponentPlate getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, ComponentPlate previousData, Map<BlockPos, ComponentPlate> otherData, IComponentFactory.EnumInstantanceUse use) {
            if (previousData != null) {
                return previousData;
            }
            if (this.height == -1) {
                if (use == IComponentFactory.EnumInstantanceUse.PLACEMENT) {
                    this.height = pos.func_177956_o();
                    PartCircuit.selectionBoxOffset = (float)(2 * this.height) / 16.0f;
                }
                return new ComponentPlate(circuit);
            }
            if (pos.func_177956_o() == this.height) {
                return new ComponentPlate(circuit);
            }
            return null;
        }

        @Override
        public boolean placeComponent(ICircuit circuit, BlockPos pos, ComponentPlate data, IComponentFactory.EnumPlacementType type, Map<BlockPos, ComponentPlate> otherData, boolean simulate) {
            return circuit.addComponent(pos, data, simulate);
        }

        @Override
        public void onStartDrawing(EntityPlayer player) {
        }

        @Override
        public void onFinishDrawing(EntityPlayer player) {
            this.height = -1;
            PartCircuit.selectionBoxOffset = 0.0f;
        }

        @Override
        public ComponentPlate instantiate(ICircuit circuit) {
            return new ComponentPlate(circuit);
        }
    }
}

