/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.analogue;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.ComponentFaceRotatable;
import com.amadornes.rscircuits.component.ComponentRegistry;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class ComponentMath
extends ComponentFaceRotatable {
    private final Factory factory;
    private byte[] input = new byte[5];
    private byte output;

    public ComponentMath(ICircuit circuit, int rotation, Factory factory) {
        super(circuit, EnumComponentSlot.BOTTOM, rotation);
        this.factory = factory;
    }

    public ComponentMath(ICircuit circuit, Factory factory) {
        super(circuit, EnumComponentSlot.BOTTOM);
        this.factory = factory;
    }

    @Override
    public ResourceLocation getName() {
        return this.factory.name;
    }

    @Override
    public float getComplexity() {
        return 0.01f;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public IBlockState getActualState() {
        return super.getActualState().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(this.rotation));
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return slot == this.slot && this.factory.type.isInput.test(side, this.rotation);
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return slot == this.slot && this.factory.type.isOutput.test(side, this.rotation);
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return this.output;
    }

    @Override
    public void onAddedPost() {
        for (EnumCircuitSide s : EnumCircuitSide.HORIZONTALS) {
            this.onChangeInput(s);
        }
        this.onChange();
    }

    @Override
    public void rotatePost() {
        super.rotatePost();
        for (EnumCircuitSide s : EnumCircuitSide.HORIZONTALS) {
            this.onChangeInput(s);
        }
        this.onChange();
    }

    @Override
    public void onScheduledTick(int type, Object data) {
        byte prev = this.output;
        this.output = (Byte)data;
        if (prev != this.output) {
            this.getCircuit().notifyUpdateAll(this.getPos(), EnumComponentSlot.CENTER);
            this.getCircuit().notifyUpdateAll(this.getPos().func_177984_a(), EnumComponentSlot.CENTER);
            this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
            this.getCircuit().markDirty();
        }
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        if (side == EnumCircuitSide.BOTTOM && this.dropIfNeeded()) {
            return;
        }
        if (side != EnumCircuitSide.TOP) {
            this.onChangeInput(side);
            this.onChange();
        }
    }

    private boolean onChangeInput(EnumCircuitSide side) {
        int i;
        byte in = this.getInputAny(this.slot, side);
        int n = i = side == EnumCircuitSide.BOTTOM ? 4 : side.face.func_176736_b();
        if (in == this.input[i]) {
            return false;
        }
        this.input[i] = in;
        return true;
    }

    private void onChange() {
        EnumMap<EnumCircuitSide, Pair<IRedstoneConductor.EnumConnectionType, Byte>> connections = new EnumMap<EnumCircuitSide, Pair<IRedstoneConductor.EnumConnectionType, Byte>>(EnumCircuitSide.class);
        for (EnumCircuitSide s : EnumCircuitSide.HORIZONTALS) {
            IComponent neighbor = this.getNeighbor(this.slot, s);
            if (neighbor == null || !(neighbor instanceof IRedstoneConductor)) continue;
            connections.put(s, Pair.of((Object)((Object)this.getConnectionState((IRedstoneConductor)((Object)neighbor), s.getOpposite())), (Object)this.input[s.face.func_176736_b()]));
        }
        byte out = this.factory.type.operation.operate(this.input[EnumCircuitSide.LEFT.face.func_176736_b()], this.input[EnumCircuitSide.RIGHT.face.func_176736_b()], this.input[EnumCircuitSide.FRONT.face.func_176736_b()], this.input[EnumCircuitSide.BACK.face.func_176736_b()], this.input[4], connections, this.rotation);
        this.getCircuit().scheduleTick(this, 1, 0, out);
        this.getCircuit().markDirty();
    }

    private IRedstoneConductor.EnumConnectionType getConnectionState(IRedstoneConductor neighbor, EnumCircuitSide side) {
        return neighbor.getNeighbors()[side.ordinal()].getType();
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0));
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, this.factory.type.res.ordinal());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74773_a("in", this.input);
        tag.func_74774_a("out", this.output);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.func_74764_b("io")) {
            byte[] io = tag.func_74770_j("io");
            this.input[EnumCircuitSide.LEFT.face.func_176736_b()] = io[0];
            this.input[EnumCircuitSide.RIGHT.face.func_176736_b()] = io[1];
            this.input[EnumCircuitSide.FRONT.face.func_176736_b()] = io[2];
            this.input[EnumCircuitSide.BACK.face.func_176736_b()] = io[3];
            this.output = io[4];
        } else {
            byte[] in = tag.func_74770_j("in");
            System.arraycopy(in, 0, this.input, 0, in.length);
            this.output = tag.func_74771_c("out");
        }
    }

    private static boolean isLeft(EnumCircuitSide s, Integer r) {
        return ComponentMath.getLeft(r) == s;
    }

    private static boolean isNotLeft(EnumCircuitSide s, Integer r) {
        return !ComponentMath.isLeft(s, r);
    }

    private static EnumCircuitSide getLeft(Integer r) {
        return r == 0 ? EnumCircuitSide.RIGHT : (r == 1 ? EnumCircuitSide.BACK : (r == 2 ? EnumCircuitSide.LEFT : EnumCircuitSide.FRONT));
    }

    private static Pair<Integer, Integer> getInputs(byte l, byte r, byte f, byte b, byte b_, int rot) {
        EnumCircuitSide left = ComponentMath.getLeft(rot);
        int in1 = 0;
        int in2 = 0;
        if (left == EnumCircuitSide.LEFT) {
            in1 = l & 0xFF;
        } else {
            in2 = Math.max(in2, l & 0xFF);
        }
        if (left == EnumCircuitSide.RIGHT) {
            in1 = r & 0xFF;
        } else {
            in2 = Math.max(in2, r & 0xFF);
        }
        if (left == EnumCircuitSide.FRONT) {
            in1 = f & 0xFF;
        } else {
            in2 = Math.max(in2, f & 0xFF);
        }
        if (left == EnumCircuitSide.BACK) {
            in1 = b & 0xFF;
        } else {
            in2 = Math.max(in2, b & 0xFF);
        }
        in2 = Math.max(in2, b_ & 0xFF);
        return Pair.of((Object)in1, (Object)in2);
    }

    public static enum EnumMathComponent implements IStringSerializable
    {
        ADDER(EnumResourceType.ADDER, (l, r, f, b, b_, sides, rot) -> (byte)Math.min(255, (l & 0xFF) + (r & 0xFF) + (f & 0xFF) + (b & 0xFF) + (b_ & 0xFF)), (s, r) -> true, (s, r) -> true),
        SUBTRACTOR(EnumResourceType.SUBTRACTOR, (l, r, f, b, b_, sides, rot) -> {
            Pair in = ComponentMath.getInputs(l, r, f, b, b_, rot);
            return (byte)Math.max(0, (Integer)in.getLeft() - (Integer)in.getRight());
        }, (s, r) -> true, (x$0, x$1) -> ComponentMath.access$600(x$0, x$1)),
        MULTIPLIER(EnumResourceType.MULTIPLIER, (l, r, f, b, b_, sides, rot) -> {
            int total = 1;
            int amt = 0;
            for (EnumCircuitSide s : EnumCircuitSide.HORIZONTALS) {
                Pair pair = (Pair)sides.get((Object)s);
                if (pair == null || !((IRedstoneConductor.EnumConnectionType)((Object)((Object)pair.getKey()))).isOutput) continue;
                total *= (Byte)pair.getValue() & 0xFF;
                ++amt;
            }
            if (amt == 0) {
                return 0;
            }
            return (byte)Math.min(total, 255);
        }, (s, r) -> true, (s, r) -> true),
        DIVIDER(EnumResourceType.DIVIDER, (l, r, f, b, b_, sides, rot) -> {
            Pair in = ComponentMath.getInputs(l, r, f, b, b_, rot);
            if ((Integer)in.getRight() == 0) {
                return 0;
            }
            return (byte)Math.max(0, (int)Math.floor((float)((Integer)in.getLeft()).intValue() / (float)((Integer)in.getRight()).intValue()));
        }, (s, r) -> true, (x$0, x$1) -> ComponentMath.access$600(x$0, x$1));

        private final EnumResourceType res;
        private final IMathOperation operation;
        private final BiPredicate<EnumCircuitSide, Integer> isInput;
        private final BiPredicate<EnumCircuitSide, Integer> isOutput;

        private EnumMathComponent(EnumResourceType res, IMathOperation operation, BiPredicate<EnumCircuitSide, Integer> isInput, BiPredicate<EnumCircuitSide, Integer> isOutput) {
            this.res = res;
            this.operation = operation;
            this.isInput = isInput;
            this.isOutput = isOutput;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }

    public static interface IMathOperation {
        public byte operate(byte var1, byte var2, byte var3, byte var4, byte var5, Map<EnumCircuitSide, Pair<IRedstoneConductor.EnumConnectionType, Byte>> var6, int var7);
    }

    public static class Factory
    extends ComponentFaceRotatable.RotatableFactory<ComponentMath> {
        private final ResourceLocation name;
        private final EnumMathComponent type;

        public Factory(EnumMathComponent type) {
            this.name = new ResourceLocation("rscircuits", type.name().toLowerCase());
            this.type = type;
        }

        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{ComponentBaseInt.ROTATION});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/" + this.name.func_110623_a());
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == this.type.res.ordinal();
        }

        @Override
        public ComponentMath getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, ComponentMath previousData, Map<BlockPos, ComponentMath> otherData, IComponentFactory.EnumInstantanceUse use) {
            if (previousData != null) {
                return previousData;
            }
            return new ComponentMath(circuit, (this.getRotation(player) + 3) % 4, this);
        }

        @Override
        public ComponentMath instantiate(ICircuit circuit) {
            return new ComponentMath(circuit, this);
        }

        public void register() {
            ComponentRegistry.INSTANCE.registerFactory(this.name, this);
        }
    }
}

