/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.analogue;

import com.amadornes.rscircuits.SCM;
import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.component.ComponentFace;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.google.common.base.Supplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class ComponentConst
extends ComponentFace {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "const");
    private byte output = 0;

    public ComponentConst(ICircuit circuit) {
        super(circuit, EnumComponentSlot.BOTTOM);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.04f;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return false;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side != EnumCircuitSide.TOP;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return side.face.func_176740_k() != EnumFacing.Axis.Y ? this.output : (byte)0;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        if (heldItem != null && (heldItem.func_77973_b() == SCMItems.screwdriver || heldItem.func_77973_b() == SCMItems.multimeter)) {
            SCM.proxy.displayTimerGui((o, s) -> "Constant Output: " + o, s -> "", (Supplier<Integer>)((Supplier)() -> this.output & 0xFF), o -> {
                ByteBuf buf = Unpooled.buffer();
                buf.writeByte(o.intValue());
                this.getCircuit().sendCustomPayload(this.getPos(), this.slot, buf);
            }, 0, 255, 1.0);
            return true;
        }
        return false;
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0));
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.CONSTANT.ordinal());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("output", this.output);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.output = tag.func_74771_c("output");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeByte((int)this.output);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.output = buf.readByte();
    }

    @Override
    public void handleCustomPayload(ByteBuf buf) {
        this.output = buf.readByte();
        this.getCircuit().markDirty();
        this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
        this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
    }

    public static class Factory
    extends SimpleFactory<ComponentConst> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[0]);
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/const");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.CONSTANT.ordinal();
        }

        @Override
        public ComponentConst instantiate(ICircuit circuit) {
            return new ComponentConst(circuit);
        }
    }
}

