/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public abstract class ComponentFace
extends ComponentBaseInt {
    protected EnumComponentSlot slot = EnumComponentSlot.BOTTOM;

    public ComponentFace(ICircuit circuit, EnumComponentSlot slot) {
        super(circuit);
        this.slot = slot;
    }

    public ComponentFace(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public EnumSet<EnumComponentSlot> getSlots() {
        return EnumSet.of(this.slot);
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        super.onNeighborChange(side, slot, component, updateType);
        if (side == EnumCircuitSide.BOTTOM && this.dropIfNeeded()) {
            return;
        }
    }

    public boolean dropIfNeeded() {
        if (!this.getCircuit().isSideSolid(this.getPos().func_177977_b(), EnumCircuitSide.TOP)) {
            this.getCircuit().removeComponent(this);
            this.getDrops().forEach(this.getCircuit()::spawnStack);
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("slot", this.slot.ordinal());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.slot = EnumComponentSlot.VALUES[tag.func_74762_e("slot")];
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.slot);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        this.slot = (EnumComponentSlot)buf.func_179257_a(EnumComponentSlot.class);
    }

    @Override
    public void serializePlacement(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.slot);
    }

    @Override
    public void deserializePlacement(PacketBuffer buf) {
        this.slot = (EnumComponentSlot)buf.func_179257_a(EnumComponentSlot.class);
    }
}

