/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.command;

import com.amadornes.rscircuits.SCM;
import com.amadornes.rscircuits.item.ICircuitStorage;
import com.amadornes.rscircuits.util.GistPublisher;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.codec.binary.Base64;

public class CommandImport
extends CommandBase {
    public String func_71517_b() {
        return "import";
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) throw new CommandException("You must be a player to use this command!", new Object[0]);
        EntityPlayer player = (EntityPlayer)sender;
        ItemStack stack = player.func_184614_ca();
        if (stack == null || !(stack.func_77973_b() instanceof ICircuitStorage) || !((ICircuitStorage)stack.func_77973_b()).canOverrideCircuitData(player, stack)) throw new CommandException("You must have an empty blueprint in your hand!", new Object[0]);
        if (args.length != 1) throw new CommandException("No URL specified!", new Object[0]);
        String url = args[0].replaceAll("\\.com/[^/]+/", "\\.com/");
        if (!url.matches("https?:\\/\\/gist\\.github\\.com\\/\\w{32}")) {
            throw new CommandException("Invalid URL!", new Object[0]);
        }
        new Thread(() -> {
            try {
                String b64Data = GistPublisher.load(url, "blueprint");
                byte[] data = Base64.decodeBase64((String)b64Data);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)bais);
                bais.close();
                ActionResult<ItemStack> result = ((ICircuitStorage)stack.func_77973_b()).overrideCircuitData(player, stack, tag);
                if (result.func_188397_a() == EnumActionResult.SUCCESS) {
                    player.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)result.func_188398_b());
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Loaded blueprint!"));
                } else {
                    SCM.log.error("Failed to update blueprint!");
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to update blueprint!"));
                }
            }
            catch (Exception e) {
                SCM.log.error("Error while reading blueprint gist", (Throwable)e);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error while reading blueprint gist"));
            }
        }).start();
    }
}

