/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.client;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ModelTransformer {
    public static IBakedModel transformLive(IBakedModel model, IVertexTransformer transformer) {
        return ModelTransformer.transformLive(model, transformer, (Function<VertexFormat, VertexFormat>)((Function)f -> f));
    }

    public static IBakedModel transformLive(IBakedModel model, IVertexTransformer transformer, Function<VertexFormat, VertexFormat> formatRemapper) {
        return model instanceof IPerspectiveAwareModel ? new LiveTransformedPerspectiveModel(model, transformer, formatRemapper) : new LiveTransformedModel(model, transformer, formatRemapper);
    }

    public static IBakedModel transform(IBakedModel model, IVertexTransformer transformer, IBlockState state, long rand) {
        return ModelTransformer.transform(model, transformer, state, rand, (Function<VertexFormat, VertexFormat>)((Function)f -> f));
    }

    public static IBakedModel transform(IBakedModel model, IVertexTransformer transformer, IBlockState state, long rand, Function<VertexFormat, VertexFormat> formatRemapper) {
        List[] quads = new List[7];
        for (int i = 0; i < quads.length; ++i) {
            quads[i] = new ArrayList();
            for (BakedQuad quad : model.func_188616_a(state, i == 6 ? null : EnumFacing.func_82600_a((int)i), rand)) {
                quads[i].add(ModelTransformer.transform(quad, transformer, formatRemapper));
            }
        }
        return new TransformedModel(model, quads);
    }

    public static BakedQuad transform(BakedQuad quad, IVertexTransformer transformer) {
        return ModelTransformer.transform(quad, transformer, (Function<VertexFormat, VertexFormat>)((Function)f -> f));
    }

    public static BakedQuad transform(BakedQuad quad, IVertexTransformer transformer, Function<VertexFormat, VertexFormat> formatRemapper) {
        VertexFormat format = quad.getFormat();
        VertexFormat newFormat = (VertexFormat)formatRemapper.apply((Object)format);
        Field f = ReflectionHelper.findField(UnpackedBakedQuad.class, (String[])new String[]{"unpackedData"});
        f.setAccessible(true);
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
        if (quad.func_178212_b()) {
            builder.setQuadTint(quad.func_178211_c());
        }
        builder.setQuadOrientation(quad.func_178210_d());
        LightUtil.putBakedQuad((IVertexConsumer)builder, (BakedQuad)quad);
        UnpackedBakedQuad unpackedQuad = builder.build();
        try {
            float[][][] unpackedData = (float[][][])f.get(unpackedQuad);
            int count = newFormat.func_177345_h();
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < count; ++e) {
                    VertexFormatElement element = newFormat.func_177348_c(e);
                    unpackedData[v][e] = transformer.transform(quad, element.func_177367_b(), element.func_177375_c(), unpackedData[v][e]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unpackedQuad;
    }

    public static interface IVertexTransformer {
        public float[] transform(BakedQuad var1, VertexFormatElement.EnumType var2, VertexFormatElement.EnumUsage var3, float ... var4);
    }

    private static final class TransformedModel
    implements IBakedModel {
        private final IBakedModel parent;
        private final List<BakedQuad>[] quads;

        public TransformedModel(IBakedModel parent, List<BakedQuad>[] quads) {
            this.parent = parent;
            this.quads = quads;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return this.quads[side == null ? 6 : side.ordinal()];
        }

        public boolean func_177555_b() {
            return this.parent.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.parent.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.parent.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.parent.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.parent.func_177552_f();
        }

        public ItemOverrideList func_188617_f() {
            return this.parent.func_188617_f();
        }
    }

    private static class LiveTransformedPerspectiveModel
    extends LiveTransformedModel
    implements IPerspectiveAwareModel {
        private final Cache<IBakedModel, IBakedModel> modelCache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
        private IPerspectiveAwareModel parent;

        public LiveTransformedPerspectiveModel(IBakedModel parent, IVertexTransformer transformer, Function<VertexFormat, VertexFormat> formatRemapper) {
            super(parent, transformer, formatRemapper);
            this.parent = (IPerspectiveAwareModel)parent;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair pair = this.parent.handlePerspective(cameraTransformType);
            try {
                return pair.getKey() == this.parent || pair.getKey() == this ? Pair.of((Object)this, (Object)pair.getValue()) : Pair.of((Object)this.modelCache.get(pair.getKey(), () -> new LiveTransformedModel((IBakedModel)pair.getKey(), this.transformer, (Function<VertexFormat, VertexFormat>)this.formatRemapper)), (Object)pair.getValue());
            }
            catch (ExecutionException e) {
                return pair;
            }
        }
    }

    private static class LiveTransformedModel
    implements IBakedModel {
        private final IBakedModel parent;
        protected IVertexTransformer transformer;
        protected Function<VertexFormat, VertexFormat> formatRemapper;

        public LiveTransformedModel(IBakedModel parent, IVertexTransformer transformer, Function<VertexFormat, VertexFormat> formatRemapper) {
            this.parent = parent;
            this.transformer = transformer;
            this.formatRemapper = formatRemapper;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (BakedQuad quad : this.parent.func_188616_a(state, side, rand)) {
                quads.add(ModelTransformer.transform(quad, this.transformer, this.formatRemapper));
            }
            return quads;
        }

        public boolean func_177555_b() {
            return this.parent.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.parent.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.parent.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.parent.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.parent.func_177552_f();
        }

        public ItemOverrideList func_188617_f() {
            return this.parent.func_188617_f();
        }
    }
}

