/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.api.circuit;

import com.amadornes.rscircuits.api.circuit.EnumCircuitIOMode;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ICircuit {
    public World getWorld();

    public BlockPos getPos();

    public EnumFacing getFace();

    public boolean isEncapsulated();

    public EnumCircuitIOMode getIOMode(EnumCircuitSide var1);

    public IComponent getComponent(BlockPos var1, EnumComponentSlot var2);

    public boolean addComponent(BlockPos var1, IComponent var2, boolean var3);

    public void removeComponent(IComponent var1);

    public void replaceComponent(IComponent var1, IComponent var2);

    public boolean isSideSolid(BlockPos var1, EnumCircuitSide var2);

    public void scheduleTick(IComponent var1, int var2, int var3, Object var4);

    public void notifyUpdate(BlockPos var1, EnumComponentSlot var2, EnumCircuitSide ... var3);

    public void notifyUpdateAll(BlockPos var1, EnumComponentSlot var2);

    public void sendUpdate(BlockPos var1, EnumComponentSlot var2, boolean var3);

    public void markDirty();

    public ICircuit getCircuit(BlockPos var1);

    public byte getInput(EnumCircuitSide var1, EnumDyeColor var2, boolean var3);

    public void sendCustomPayload(BlockPos var1, EnumComponentSlot var2, ByteBuf var3);

    public void spawnMagicSmoke(BlockPos var1);

    public void spawnStack(ItemStack var1);

    public void rotate(Rotation var1);

    public float computeComplexity();
}

