/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.tile.generator.tier3;

import com.valkyrieofnight.simplegenerators.core.SGConfig;
import com.valkyrieofnight.simplegenerators.tile.generator.tier2.TileLavaGenT2;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileLavaGenT3
extends TileLavaGenT2 {
    private static int TOTAL_GEN = 4000;

    public TileLavaGenT3() {
        this.setBufferSize(SGConfig.lava_buffer * 4);
    }

    @Override
    protected int getRFT() {
        return SGConfig.lava_rft * SGConfig.tier2_multiplier * SGConfig.tier2_multiplier;
    }

    @Override
    public int getRFTFromFluid(FluidStack fluid) {
        if (fluid == null) {
            return 0;
        }
        if (fluid.getFluid() == FluidRegistry.LAVA) {
            return this.getRFT();
        }
        return 0;
    }

    @Override
    public int getDurationFromFluid(FluidStack fluid) {
        if (fluid != null && fluid.getFluid() == FluidRegistry.LAVA) {
            return TOTAL_GEN * SGConfig.tier2_multiplier / this.getRFTFromFluid(fluid);
        }
        return 0;
    }

    @Override
    public boolean isValidFuel(FluidStack fluid) {
        if (fluid == null) {
            return false;
        }
        return fluid.getFluid() == FluidRegistry.LAVA;
    }

    @Override
    public boolean shouldConsumeAndGen(FluidStack fluid) {
        return false;
    }

    @Override
    public int getConsumptionPerDuration(FluidStack fluid) {
        return SGConfig.lava_mb_per_operation * SGConfig.tier2_multiplier;
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.values();
    }
}

