/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.tile.generator;

import com.valkyrieofnight.simplegenerators.core.SGConfig;
import com.valkyrieofnight.simplegenerators.tile.TileGeneratorSingleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileFurnaceGen
extends TileGeneratorSingleItem {
    public TileFurnaceGen() {
        super(SGConfig.furnace_buffer);
    }

    @Override
    public int getRFTFromItem(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return 0;
        }
        int fuel = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (fuel * 20 < SGConfig.furnace_rft) {
            return fuel * 20;
        }
        return SGConfig.furnace_rft;
    }

    @Override
    public int getDurationFromItem(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return 0;
        }
        int bt = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (bt == 0) {
            return 0;
        }
        return bt * 20 / this.getRFTFromItem(stack);
    }

    @Override
    public boolean isValidFuel(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return false;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.values();
    }
}

